package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  SequenceStoreId,
  NextToken,
  ListReadSetImportJobsRequestMaxResultsInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListReadSetImportJobsRequest(
    maxResults: Optional[ListReadSetImportJobsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    sequenceStoreId: SequenceStoreId,
    filter: Optional[zio.aws.omics.model.ImportReadSetFilter] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest = {
    import ListReadSetImportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListReadSetImportJobsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListReadSetImportJobsRequest.ReadOnly =
    zio.aws.omics.model.ListReadSetImportJobsRequest.wrap(buildAwsValue())
}
object ListReadSetImportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListReadSetImportJobsRequest =
      zio.aws.omics.model.ListReadSetImportJobsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        sequenceStoreId,
        filter.map(value => value.asEditable)
      )
    def maxResults: Optional[ListReadSetImportJobsRequestMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def sequenceStoreId: SequenceStoreId
    def filter: Optional[zio.aws.omics.model.ImportReadSetFilter.ReadOnly]
    def getMaxResults
        : ZIO[Any, AwsError, ListReadSetImportJobsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.omics.model.ImportReadSetFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest
  ) extends zio.aws.omics.model.ListReadSetImportJobsRequest.ReadOnly {
    override val maxResults
        : Optional[ListReadSetImportJobsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListReadSetImportJobsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val filter
        : Optional[zio.aws.omics.model.ImportReadSetFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.omics.model.ImportReadSetFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest
  ): zio.aws.omics.model.ListReadSetImportJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
