package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListReadSetImportJobsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    importJobs: Optional[Iterable[zio.aws.omics.model.ImportReadSetJobItem]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse = {
    import ListReadSetImportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        importJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.importJobs)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListReadSetImportJobsResponse.ReadOnly =
    zio.aws.omics.model.ListReadSetImportJobsResponse.wrap(buildAwsValue())
}
object ListReadSetImportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListReadSetImportJobsResponse =
      zio.aws.omics.model.ListReadSetImportJobsResponse(
        nextToken.map(value => value),
        importJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def importJobs
        : Optional[List[zio.aws.omics.model.ImportReadSetJobItem.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getImportJobs: ZIO[Any, AwsError, List[
      zio.aws.omics.model.ImportReadSetJobItem.ReadOnly
    ]] = AwsError.unwrapOptionField("importJobs", importJobs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse
  ) extends zio.aws.omics.model.ListReadSetImportJobsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
    override val importJobs
        : Optional[List[zio.aws.omics.model.ImportReadSetJobItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importJobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.omics.model.ImportReadSetJobItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse
  ): zio.aws.omics.model.ListReadSetImportJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
