package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  NextToken,
  ListReadSetUploadPartsRequestMaxResultsInteger,
  UploadId,
  SequenceStoreId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListReadSetUploadPartsRequest(
    sequenceStoreId: SequenceStoreId,
    uploadId: UploadId,
    partSource: zio.aws.omics.model.ReadSetPartSource,
    maxResults: Optional[ListReadSetUploadPartsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    filter: Optional[zio.aws.omics.model.ReadSetUploadPartListFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsRequest = {
    import ListReadSetUploadPartsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsRequest
      .builder()
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .uploadId(UploadId.unwrap(uploadId): java.lang.String)
      .partSource(partSource.unwrap)
      .optionallyWith(
        maxResults.map(value =>
          ListReadSetUploadPartsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListReadSetUploadPartsRequest.ReadOnly =
    zio.aws.omics.model.ListReadSetUploadPartsRequest.wrap(buildAwsValue())
}
object ListReadSetUploadPartsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListReadSetUploadPartsRequest =
      zio.aws.omics.model.ListReadSetUploadPartsRequest(
        sequenceStoreId,
        uploadId,
        partSource,
        maxResults.map(value => value),
        nextToken.map(value => value),
        filter.map(value => value.asEditable)
      )
    def sequenceStoreId: SequenceStoreId
    def uploadId: UploadId
    def partSource: zio.aws.omics.model.ReadSetPartSource
    def maxResults: Optional[ListReadSetUploadPartsRequestMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def filter
        : Optional[zio.aws.omics.model.ReadSetUploadPartListFilter.ReadOnly]
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getUploadId: ZIO[Any, Nothing, UploadId] = ZIO.succeed(uploadId)
    def getPartSource
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetPartSource] =
      ZIO.succeed(partSource)
    def getMaxResults
        : ZIO[Any, AwsError, ListReadSetUploadPartsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.omics.model.ReadSetUploadPartListFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsRequest
  ) extends zio.aws.omics.model.ListReadSetUploadPartsRequest.ReadOnly {
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val uploadId: UploadId =
      zio.aws.omics.model.primitives.UploadId(impl.uploadId())
    override val partSource: zio.aws.omics.model.ReadSetPartSource =
      zio.aws.omics.model.ReadSetPartSource.wrap(impl.partSource())
    override val maxResults
        : Optional[ListReadSetUploadPartsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListReadSetUploadPartsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
    override val filter
        : Optional[zio.aws.omics.model.ReadSetUploadPartListFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          zio.aws.omics.model.ReadSetUploadPartListFilter.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsRequest
  ): zio.aws.omics.model.ListReadSetUploadPartsRequest.ReadOnly = new Wrapper(
    impl
  )
}
