package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListReadSetUploadPartsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    parts: Optional[Iterable[zio.aws.omics.model.ReadSetUploadPartListItem]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsResponse = {
    import ListReadSetUploadPartsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        parts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parts)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListReadSetUploadPartsResponse.ReadOnly =
    zio.aws.omics.model.ListReadSetUploadPartsResponse.wrap(buildAwsValue())
}
object ListReadSetUploadPartsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListReadSetUploadPartsResponse =
      zio.aws.omics.model.ListReadSetUploadPartsResponse(
        nextToken.map(value => value),
        parts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def parts
        : Optional[List[zio.aws.omics.model.ReadSetUploadPartListItem.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getParts: ZIO[Any, AwsError, List[
      zio.aws.omics.model.ReadSetUploadPartListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("parts", parts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsResponse
  ) extends zio.aws.omics.model.ListReadSetUploadPartsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
    override val parts: Optional[
      List[zio.aws.omics.model.ReadSetUploadPartListItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.omics.model.ReadSetUploadPartListItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsResponse
  ): zio.aws.omics.model.ListReadSetUploadPartsResponse.ReadOnly = new Wrapper(
    impl
  )
}
