package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListReadSetsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    readSets: Iterable[zio.aws.omics.model.ReadSetListItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListReadSetsResponse = {
    import ListReadSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListReadSetsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .readSets(readSets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListReadSetsResponse.ReadOnly =
    zio.aws.omics.model.ListReadSetsResponse.wrap(buildAwsValue())
}
object ListReadSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListReadSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListReadSetsResponse =
      zio.aws.omics.model.ListReadSetsResponse(
        nextToken.map(value => value),
        readSets.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def readSets: List[zio.aws.omics.model.ReadSetListItem.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReadSets: ZIO[Any, Nothing, List[
      zio.aws.omics.model.ReadSetListItem.ReadOnly
    ]] = ZIO.succeed(readSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetsResponse
  ) extends zio.aws.omics.model.ListReadSetsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
    override val readSets: List[zio.aws.omics.model.ReadSetListItem.ReadOnly] =
      impl
        .readSets()
        .asScala
        .map { item =>
          zio.aws.omics.model.ReadSetListItem.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetsResponse
  ): zio.aws.omics.model.ListReadSetsResponse.ReadOnly = new Wrapper(impl)
}
