package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  NextToken,
  ListReferencesRequestMaxResultsInteger,
  ReferenceStoreId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListReferencesRequest(
    referenceStoreId: ReferenceStoreId,
    maxResults: Optional[ListReferencesRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    filter: Optional[zio.aws.omics.model.ReferenceFilter] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListReferencesRequest = {
    import ListReferencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListReferencesRequest
      .builder()
      .referenceStoreId(
        ReferenceStoreId.unwrap(referenceStoreId): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value =>
          ListReferencesRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListReferencesRequest.ReadOnly =
    zio.aws.omics.model.ListReferencesRequest.wrap(buildAwsValue())
}
object ListReferencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListReferencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListReferencesRequest =
      zio.aws.omics.model.ListReferencesRequest(
        referenceStoreId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        filter.map(value => value.asEditable)
      )
    def referenceStoreId: ReferenceStoreId
    def maxResults: Optional[ListReferencesRequestMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def filter: Optional[zio.aws.omics.model.ReferenceFilter.ReadOnly]
    def getReferenceStoreId: ZIO[Any, Nothing, ReferenceStoreId] =
      ZIO.succeed(referenceStoreId)
    def getMaxResults
        : ZIO[Any, AwsError, ListReferencesRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.omics.model.ReferenceFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListReferencesRequest
  ) extends zio.aws.omics.model.ListReferencesRequest.ReadOnly {
    override val referenceStoreId: ReferenceStoreId =
      zio.aws.omics.model.primitives.ReferenceStoreId(impl.referenceStoreId())
    override val maxResults: Optional[ListReferencesRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListReferencesRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
    override val filter
        : Optional[zio.aws.omics.model.ReferenceFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.omics.model.ReferenceFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListReferencesRequest
  ): zio.aws.omics.model.ListReferencesRequest.ReadOnly = new Wrapper(impl)
}
