package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.RunGroupListToken
import scala.jdk.CollectionConverters._
final case class ListRunGroupsResponse(
    items: Optional[Iterable[zio.aws.omics.model.RunGroupListItem]] =
      Optional.Absent,
    nextToken: Optional[RunGroupListToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListRunGroupsResponse = {
    import ListRunGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListRunGroupsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value =>
          RunGroupListToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListRunGroupsResponse.ReadOnly =
    zio.aws.omics.model.ListRunGroupsResponse.wrap(buildAwsValue())
}
object ListRunGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListRunGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListRunGroupsResponse =
      zio.aws.omics.model.ListRunGroupsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[List[zio.aws.omics.model.RunGroupListItem.ReadOnly]]
    def nextToken: Optional[RunGroupListToken]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.omics.model.RunGroupListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, RunGroupListToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListRunGroupsResponse
  ) extends zio.aws.omics.model.ListRunGroupsResponse.ReadOnly {
    override val items
        : Optional[List[zio.aws.omics.model.RunGroupListItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.omics.model.RunGroupListItem.wrap(item)
          }.toList
        )
    override val nextToken: Optional[RunGroupListToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.RunGroupListToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListRunGroupsResponse
  ): zio.aws.omics.model.ListRunGroupsResponse.ReadOnly = new Wrapper(impl)
}
