package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.TaskListToken
import scala.jdk.CollectionConverters._
final case class ListRunTasksResponse(
    items: Optional[Iterable[zio.aws.omics.model.TaskListItem]] =
      Optional.Absent,
    nextToken: Optional[TaskListToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListRunTasksResponse = {
    import ListRunTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListRunTasksResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => TaskListToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListRunTasksResponse.ReadOnly =
    zio.aws.omics.model.ListRunTasksResponse.wrap(buildAwsValue())
}
object ListRunTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListRunTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListRunTasksResponse =
      zio.aws.omics.model.ListRunTasksResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[List[zio.aws.omics.model.TaskListItem.ReadOnly]]
    def nextToken: Optional[TaskListToken]
    def getItems
        : ZIO[Any, AwsError, List[zio.aws.omics.model.TaskListItem.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, TaskListToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListRunTasksResponse
  ) extends zio.aws.omics.model.ListRunTasksResponse.ReadOnly {
    override val items
        : Optional[List[zio.aws.omics.model.TaskListItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.omics.model.TaskListItem.wrap(item)
          }.toList
        )
    override val nextToken: Optional[TaskListToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.TaskListToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListRunTasksResponse
  ): zio.aws.omics.model.ListRunTasksResponse.ReadOnly = new Wrapper(impl)
}
