package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ListRunsRequestMaxResultsInteger,
  RunListToken,
  RunGroupId,
  RunName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRunsRequest(
    name: Optional[RunName] = Optional.Absent,
    runGroupId: Optional[RunGroupId] = Optional.Absent,
    startingToken: Optional[RunListToken] = Optional.Absent,
    maxResults: Optional[ListRunsRequestMaxResultsInteger] = Optional.Absent,
    status: Optional[zio.aws.omics.model.RunStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListRunsRequest = {
    import ListRunsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListRunsRequest
      .builder()
      .optionallyWith(
        name.map(value => RunName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        runGroupId.map(value => RunGroupId.unwrap(value): java.lang.String)
      )(_.runGroupId)
      .optionallyWith(
        startingToken.map(value => RunListToken.unwrap(value): java.lang.String)
      )(_.startingToken)
      .optionallyWith(
        maxResults.map(value =>
          ListRunsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListRunsRequest.ReadOnly =
    zio.aws.omics.model.ListRunsRequest.wrap(buildAwsValue())
}
object ListRunsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListRunsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListRunsRequest =
      zio.aws.omics.model.ListRunsRequest(
        name.map(value => value),
        runGroupId.map(value => value),
        startingToken.map(value => value),
        maxResults.map(value => value),
        status.map(value => value)
      )
    def name: Optional[RunName]
    def runGroupId: Optional[RunGroupId]
    def startingToken: Optional[RunListToken]
    def maxResults: Optional[ListRunsRequestMaxResultsInteger]
    def status: Optional[zio.aws.omics.model.RunStatus]
    def getName: ZIO[Any, AwsError, RunName] =
      AwsError.unwrapOptionField("name", name)
    def getRunGroupId: ZIO[Any, AwsError, RunGroupId] =
      AwsError.unwrapOptionField("runGroupId", runGroupId)
    def getStartingToken: ZIO[Any, AwsError, RunListToken] =
      AwsError.unwrapOptionField("startingToken", startingToken)
    def getMaxResults: ZIO[Any, AwsError, ListRunsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.RunStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListRunsRequest
  ) extends zio.aws.omics.model.ListRunsRequest.ReadOnly {
    override val name: Optional[RunName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.RunName(value))
    override val runGroupId: Optional[RunGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.runGroupId())
      .map(value => zio.aws.omics.model.primitives.RunGroupId(value))
    override val startingToken: Optional[RunListToken] = zio.aws.core.internal
      .optionalFromNullable(impl.startingToken())
      .map(value => zio.aws.omics.model.primitives.RunListToken(value))
    override val maxResults: Optional[ListRunsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives.ListRunsRequestMaxResultsInteger(value)
        )
    override val status: Optional[zio.aws.omics.model.RunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.RunStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListRunsRequest
  ): zio.aws.omics.model.ListRunsRequest.ReadOnly = new Wrapper(impl)
}
