package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  NextToken,
  ListSequenceStoresRequestMaxResultsInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSequenceStoresRequest(
    maxResults: Optional[ListSequenceStoresRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    filter: Optional[zio.aws.omics.model.SequenceStoreFilter] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest = {
    import ListSequenceStoresRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListSequenceStoresRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListSequenceStoresRequest.ReadOnly =
    zio.aws.omics.model.ListSequenceStoresRequest.wrap(buildAwsValue())
}
object ListSequenceStoresRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListSequenceStoresRequest =
      zio.aws.omics.model.ListSequenceStoresRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        filter.map(value => value.asEditable)
      )
    def maxResults: Optional[ListSequenceStoresRequestMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def filter: Optional[zio.aws.omics.model.SequenceStoreFilter.ReadOnly]
    def getMaxResults
        : ZIO[Any, AwsError, ListSequenceStoresRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.omics.model.SequenceStoreFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest
  ) extends zio.aws.omics.model.ListSequenceStoresRequest.ReadOnly {
    override val maxResults
        : Optional[ListSequenceStoresRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListSequenceStoresRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
    override val filter
        : Optional[zio.aws.omics.model.SequenceStoreFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.omics.model.SequenceStoreFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest
  ): zio.aws.omics.model.ListSequenceStoresRequest.ReadOnly = new Wrapper(impl)
}
