package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.TagArn
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: TagArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(TagArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.omics.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListTagsForResourceRequest =
      zio.aws.omics.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: TagArn
    def getResourceArn: ZIO[Any, Nothing, TagArn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListTagsForResourceRequest
  ) extends zio.aws.omics.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: TagArn =
      zio.aws.omics.model.primitives.TagArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListTagsForResourceRequest
  ): zio.aws.omics.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(impl)
}
