package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ListVariantImportJobsRequestNextTokenString,
  ResourceIdentifier,
  ListVariantImportJobsRequestMaxResultsInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListVariantImportJobsRequest(
    maxResults: Optional[ListVariantImportJobsRequestMaxResultsInteger] =
      Optional.Absent,
    ids: Optional[Iterable[ResourceIdentifier]] = Optional.Absent,
    nextToken: Optional[ListVariantImportJobsRequestNextTokenString] =
      Optional.Absent,
    filter: Optional[zio.aws.omics.model.ListVariantImportJobsFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest = {
    import ListVariantImportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListVariantImportJobsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        ids.map(value =>
          value.map { item =>
            ResourceIdentifier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ids)
      .optionallyWith(
        nextToken.map(value =>
          ListVariantImportJobsRequestNextTokenString.unwrap(
            value
          ): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListVariantImportJobsRequest.ReadOnly =
    zio.aws.omics.model.ListVariantImportJobsRequest.wrap(buildAwsValue())
}
object ListVariantImportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListVariantImportJobsRequest =
      zio.aws.omics.model.ListVariantImportJobsRequest(
        maxResults.map(value => value),
        ids.map(value => value),
        nextToken.map(value => value),
        filter.map(value => value.asEditable)
      )
    def maxResults: Optional[ListVariantImportJobsRequestMaxResultsInteger]
    def ids: Optional[List[ResourceIdentifier]]
    def nextToken: Optional[ListVariantImportJobsRequestNextTokenString]
    def filter
        : Optional[zio.aws.omics.model.ListVariantImportJobsFilter.ReadOnly]
    def getMaxResults
        : ZIO[Any, AwsError, ListVariantImportJobsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getIds: ZIO[Any, AwsError, List[ResourceIdentifier]] =
      AwsError.unwrapOptionField("ids", ids)
    def getNextToken
        : ZIO[Any, AwsError, ListVariantImportJobsRequestNextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.omics.model.ListVariantImportJobsFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest
  ) extends zio.aws.omics.model.ListVariantImportJobsRequest.ReadOnly {
    override val maxResults
        : Optional[ListVariantImportJobsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListVariantImportJobsRequestMaxResultsInteger(value)
        )
    override val ids: Optional[List[ResourceIdentifier]] = zio.aws.core.internal
      .optionalFromNullable(impl.ids())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.omics.model.primitives.ResourceIdentifier(item)
        }.toList
      )
    override val nextToken
        : Optional[ListVariantImportJobsRequestNextTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListVariantImportJobsRequestNextTokenString(value)
        )
    override val filter
        : Optional[zio.aws.omics.model.ListVariantImportJobsFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          zio.aws.omics.model.ListVariantImportJobsFilter.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest
  ): zio.aws.omics.model.ListVariantImportJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
