package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVariantImportJobsResponse(
    variantImportJobs: Optional[
      Iterable[zio.aws.omics.model.VariantImportJobItem]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse = {
    import ListVariantImportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse
      .builder()
      .optionallyWith(
        variantImportJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.variantImportJobs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListVariantImportJobsResponse.ReadOnly =
    zio.aws.omics.model.ListVariantImportJobsResponse.wrap(buildAwsValue())
}
object ListVariantImportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListVariantImportJobsResponse =
      zio.aws.omics.model.ListVariantImportJobsResponse(
        variantImportJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def variantImportJobs
        : Optional[List[zio.aws.omics.model.VariantImportJobItem.ReadOnly]]
    def nextToken: Optional[String]
    def getVariantImportJobs: ZIO[Any, AwsError, List[
      zio.aws.omics.model.VariantImportJobItem.ReadOnly
    ]] = AwsError.unwrapOptionField("variantImportJobs", variantImportJobs)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse
  ) extends zio.aws.omics.model.ListVariantImportJobsResponse.ReadOnly {
    override val variantImportJobs
        : Optional[List[zio.aws.omics.model.VariantImportJobItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.variantImportJobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.omics.model.VariantImportJobItem.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse
  ): zio.aws.omics.model.ListVariantImportJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
