package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVariantStoresFilter(
    status: Optional[zio.aws.omics.model.StoreStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListVariantStoresFilter = {
    import ListVariantStoresFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListVariantStoresFilter
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListVariantStoresFilter.ReadOnly =
    zio.aws.omics.model.ListVariantStoresFilter.wrap(buildAwsValue())
}
object ListVariantStoresFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListVariantStoresFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListVariantStoresFilter =
      zio.aws.omics.model.ListVariantStoresFilter(status.map(value => value))
    def status: Optional[zio.aws.omics.model.StoreStatus]
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.StoreStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListVariantStoresFilter
  ) extends zio.aws.omics.model.ListVariantStoresFilter.ReadOnly {
    override val status: Optional[zio.aws.omics.model.StoreStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.StoreStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListVariantStoresFilter
  ): zio.aws.omics.model.ListVariantStoresFilter.ReadOnly = new Wrapper(impl)
}
