package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ListVariantStoresRequestNextTokenString,
  ResourceIdentifier,
  ListVariantStoresRequestMaxResultsInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListVariantStoresRequest(
    maxResults: Optional[ListVariantStoresRequestMaxResultsInteger] =
      Optional.Absent,
    ids: Optional[Iterable[ResourceIdentifier]] = Optional.Absent,
    nextToken: Optional[ListVariantStoresRequestNextTokenString] =
      Optional.Absent,
    filter: Optional[zio.aws.omics.model.ListVariantStoresFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListVariantStoresRequest = {
    import ListVariantStoresRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListVariantStoresRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListVariantStoresRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        ids.map(value =>
          value.map { item =>
            ResourceIdentifier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ids)
      .optionallyWith(
        nextToken.map(value =>
          ListVariantStoresRequestNextTokenString.unwrap(
            value
          ): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListVariantStoresRequest.ReadOnly =
    zio.aws.omics.model.ListVariantStoresRequest.wrap(buildAwsValue())
}
object ListVariantStoresRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListVariantStoresRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListVariantStoresRequest =
      zio.aws.omics.model.ListVariantStoresRequest(
        maxResults.map(value => value),
        ids.map(value => value),
        nextToken.map(value => value),
        filter.map(value => value.asEditable)
      )
    def maxResults: Optional[ListVariantStoresRequestMaxResultsInteger]
    def ids: Optional[List[ResourceIdentifier]]
    def nextToken: Optional[ListVariantStoresRequestNextTokenString]
    def filter: Optional[zio.aws.omics.model.ListVariantStoresFilter.ReadOnly]
    def getMaxResults
        : ZIO[Any, AwsError, ListVariantStoresRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getIds: ZIO[Any, AwsError, List[ResourceIdentifier]] =
      AwsError.unwrapOptionField("ids", ids)
    def getNextToken
        : ZIO[Any, AwsError, ListVariantStoresRequestNextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.omics.model.ListVariantStoresFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListVariantStoresRequest
  ) extends zio.aws.omics.model.ListVariantStoresRequest.ReadOnly {
    override val maxResults
        : Optional[ListVariantStoresRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListVariantStoresRequestMaxResultsInteger(value)
        )
    override val ids: Optional[List[ResourceIdentifier]] = zio.aws.core.internal
      .optionalFromNullable(impl.ids())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.omics.model.primitives.ResourceIdentifier(item)
        }.toList
      )
    override val nextToken: Optional[ListVariantStoresRequestNextTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListVariantStoresRequestNextTokenString(value)
        )
    override val filter
        : Optional[zio.aws.omics.model.ListVariantStoresFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.omics.model.ListVariantStoresFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListVariantStoresRequest
  ): zio.aws.omics.model.ListVariantStoresRequest.ReadOnly = new Wrapper(impl)
}
