package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{
  Separator,
  QuoteAll,
  Quote,
  LineSep,
  EscapeQuotes,
  CommentChar,
  Encoding,
  Header,
  EscapeChar
}
import scala.jdk.CollectionConverters._
final case class ReadOptions(
    sep: Optional[Separator] = Optional.Absent,
    encoding: Optional[Encoding] = Optional.Absent,
    quote: Optional[Quote] = Optional.Absent,
    quoteAll: Optional[QuoteAll] = Optional.Absent,
    escape: Optional[EscapeChar] = Optional.Absent,
    escapeQuotes: Optional[EscapeQuotes] = Optional.Absent,
    comment: Optional[CommentChar] = Optional.Absent,
    header: Optional[Header] = Optional.Absent,
    lineSep: Optional[LineSep] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ReadOptions = {
    import ReadOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ReadOptions
      .builder()
      .optionallyWith(
        sep.map(value => Separator.unwrap(value): java.lang.String)
      )(_.sep)
      .optionallyWith(
        encoding.map(value => Encoding.unwrap(value): java.lang.String)
      )(_.encoding)
      .optionallyWith(
        quote.map(value => Quote.unwrap(value): java.lang.String)
      )(_.quote)
      .optionallyWith(
        quoteAll.map(value => QuoteAll.unwrap(value): java.lang.Boolean)
      )(_.quoteAll)
      .optionallyWith(
        escape.map(value => EscapeChar.unwrap(value): java.lang.String)
      )(_.escape)
      .optionallyWith(
        escapeQuotes.map(value => EscapeQuotes.unwrap(value): java.lang.Boolean)
      )(_.escapeQuotes)
      .optionallyWith(
        comment.map(value => CommentChar.unwrap(value): java.lang.String)
      )(_.comment)
      .optionallyWith(
        header.map(value => Header.unwrap(value): java.lang.Boolean)
      )(_.header)
      .optionallyWith(
        lineSep.map(value => LineSep.unwrap(value): java.lang.String)
      )(_.lineSep)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ReadOptions.ReadOnly =
    zio.aws.omics.model.ReadOptions.wrap(buildAwsValue())
}
object ReadOptions {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.omics.model.ReadOptions] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ReadOptions =
      zio.aws.omics.model.ReadOptions(
        sep.map(value => value),
        encoding.map(value => value),
        quote.map(value => value),
        quoteAll.map(value => value),
        escape.map(value => value),
        escapeQuotes.map(value => value),
        comment.map(value => value),
        header.map(value => value),
        lineSep.map(value => value)
      )
    def sep: Optional[Separator]
    def encoding: Optional[Encoding]
    def quote: Optional[Quote]
    def quoteAll: Optional[QuoteAll]
    def escape: Optional[EscapeChar]
    def escapeQuotes: Optional[EscapeQuotes]
    def comment: Optional[CommentChar]
    def header: Optional[Header]
    def lineSep: Optional[LineSep]
    def getSep: ZIO[Any, AwsError, Separator] =
      AwsError.unwrapOptionField("sep", sep)
    def getEncoding: ZIO[Any, AwsError, Encoding] =
      AwsError.unwrapOptionField("encoding", encoding)
    def getQuote: ZIO[Any, AwsError, Quote] =
      AwsError.unwrapOptionField("quote", quote)
    def getQuoteAll: ZIO[Any, AwsError, QuoteAll] =
      AwsError.unwrapOptionField("quoteAll", quoteAll)
    def getEscape: ZIO[Any, AwsError, EscapeChar] =
      AwsError.unwrapOptionField("escape", escape)
    def getEscapeQuotes: ZIO[Any, AwsError, EscapeQuotes] =
      AwsError.unwrapOptionField("escapeQuotes", escapeQuotes)
    def getComment: ZIO[Any, AwsError, CommentChar] =
      AwsError.unwrapOptionField("comment", comment)
    def getHeader: ZIO[Any, AwsError, Header] =
      AwsError.unwrapOptionField("header", header)
    def getLineSep: ZIO[Any, AwsError, LineSep] =
      AwsError.unwrapOptionField("lineSep", lineSep)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ReadOptions
  ) extends zio.aws.omics.model.ReadOptions.ReadOnly {
    override val sep: Optional[Separator] = zio.aws.core.internal
      .optionalFromNullable(impl.sep())
      .map(value => zio.aws.omics.model.primitives.Separator(value))
    override val encoding: Optional[Encoding] = zio.aws.core.internal
      .optionalFromNullable(impl.encoding())
      .map(value => zio.aws.omics.model.primitives.Encoding(value))
    override val quote: Optional[Quote] = zio.aws.core.internal
      .optionalFromNullable(impl.quote())
      .map(value => zio.aws.omics.model.primitives.Quote(value))
    override val quoteAll: Optional[QuoteAll] = zio.aws.core.internal
      .optionalFromNullable(impl.quoteAll())
      .map(value => zio.aws.omics.model.primitives.QuoteAll(value))
    override val escape: Optional[EscapeChar] = zio.aws.core.internal
      .optionalFromNullable(impl.escape())
      .map(value => zio.aws.omics.model.primitives.EscapeChar(value))
    override val escapeQuotes: Optional[EscapeQuotes] = zio.aws.core.internal
      .optionalFromNullable(impl.escapeQuotes())
      .map(value => zio.aws.omics.model.primitives.EscapeQuotes(value))
    override val comment: Optional[CommentChar] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => zio.aws.omics.model.primitives.CommentChar(value))
    override val header: Optional[Header] = zio.aws.core.internal
      .optionalFromNullable(impl.header())
      .map(value => zio.aws.omics.model.primitives.Header(value))
    override val lineSep: Optional[LineSep] = zio.aws.core.internal
      .optionalFromNullable(impl.lineSep())
      .map(value => zio.aws.omics.model.primitives.LineSep(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ReadOptions
  ): zio.aws.omics.model.ReadOptions.ReadOnly = new Wrapper(impl)
}
