package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.ReadSetId
import scala.jdk.CollectionConverters._
final case class ReadSetBatchError(
    id: ReadSetId,
    code: String,
    message: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ReadSetBatchError = {
    import ReadSetBatchError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ReadSetBatchError
      .builder()
      .id(ReadSetId.unwrap(id): java.lang.String)
      .code(code: java.lang.String)
      .message(message: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ReadSetBatchError.ReadOnly =
    zio.aws.omics.model.ReadSetBatchError.wrap(buildAwsValue())
}
object ReadSetBatchError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ReadSetBatchError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ReadSetBatchError =
      zio.aws.omics.model.ReadSetBatchError(id, code, message)
    def id: ReadSetId
    def code: String
    def message: String
    def getId: ZIO[Any, Nothing, ReadSetId] = ZIO.succeed(id)
    def getCode: ZIO[Any, Nothing, String] = ZIO.succeed(code)
    def getMessage: ZIO[Any, Nothing, String] = ZIO.succeed(message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ReadSetBatchError
  ) extends zio.aws.omics.model.ReadSetBatchError.ReadOnly {
    override val id: ReadSetId =
      zio.aws.omics.model.primitives.ReadSetId(impl.id())
    override val code: String = impl.code(): String
    override val message: String = impl.message(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ReadSetBatchError
  ): zio.aws.omics.model.ReadSetBatchError.ReadOnly = new Wrapper(impl)
}
