package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait ReadSetFile {
  def unwrap: software.amazon.awssdk.services.omics.model.ReadSetFile
}
object ReadSetFile {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.ReadSetFile
  ): zio.aws.omics.model.ReadSetFile = value match {
    case software.amazon.awssdk.services.omics.model.ReadSetFile.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.ReadSetFile.SOURCE1 =>
      val r = SOURCE1
      r
    case software.amazon.awssdk.services.omics.model.ReadSetFile.SOURCE2 =>
      val r = SOURCE2
      r
    case software.amazon.awssdk.services.omics.model.ReadSetFile.INDEX =>
      val r = INDEX
      r
  }
  case object unknownToSdkVersion extends zio.aws.omics.model.ReadSetFile {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReadSetFile =
      software.amazon.awssdk.services.omics.model.ReadSetFile.UNKNOWN_TO_SDK_VERSION
  }
  case object SOURCE1 extends zio.aws.omics.model.ReadSetFile {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReadSetFile =
      software.amazon.awssdk.services.omics.model.ReadSetFile.SOURCE1
  }
  case object SOURCE2 extends zio.aws.omics.model.ReadSetFile {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReadSetFile =
      software.amazon.awssdk.services.omics.model.ReadSetFile.SOURCE2
  }
  case object INDEX extends zio.aws.omics.model.ReadSetFile {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReadSetFile =
      software.amazon.awssdk.services.omics.model.ReadSetFile.INDEX
  }
}
