package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ReadSetName,
  SubjectId,
  SampleId,
  SyntheticTimestamp_date_time,
  GeneratedFrom,
  ReferenceArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ReadSetFilter(
    name: Optional[ReadSetName] = Optional.Absent,
    status: Optional[zio.aws.omics.model.ReadSetStatus] = Optional.Absent,
    referenceArn: Optional[ReferenceArn] = Optional.Absent,
    createdAfter: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    createdBefore: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    sampleId: Optional[SampleId] = Optional.Absent,
    subjectId: Optional[SubjectId] = Optional.Absent,
    generatedFrom: Optional[GeneratedFrom] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ReadSetFilter = {
    import ReadSetFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ReadSetFilter
      .builder()
      .optionallyWith(
        name.map(value => ReadSetName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        referenceArn.map(value => ReferenceArn.unwrap(value): java.lang.String)
      )(_.referenceArn)
      .optionallyWith(
        createdAfter.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAfter)
      .optionallyWith(
        createdBefore.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdBefore)
      .optionallyWith(
        sampleId.map(value => SampleId.unwrap(value): java.lang.String)
      )(_.sampleId)
      .optionallyWith(
        subjectId.map(value => SubjectId.unwrap(value): java.lang.String)
      )(_.subjectId)
      .optionallyWith(
        generatedFrom.map(value =>
          GeneratedFrom.unwrap(value): java.lang.String
        )
      )(_.generatedFrom)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ReadSetFilter.ReadOnly =
    zio.aws.omics.model.ReadSetFilter.wrap(buildAwsValue())
}
object ReadSetFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ReadSetFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ReadSetFilter =
      zio.aws.omics.model.ReadSetFilter(
        name.map(value => value),
        status.map(value => value),
        referenceArn.map(value => value),
        createdAfter.map(value => value),
        createdBefore.map(value => value),
        sampleId.map(value => value),
        subjectId.map(value => value),
        generatedFrom.map(value => value)
      )
    def name: Optional[ReadSetName]
    def status: Optional[zio.aws.omics.model.ReadSetStatus]
    def referenceArn: Optional[ReferenceArn]
    def createdAfter: Optional[SyntheticTimestamp_date_time]
    def createdBefore: Optional[SyntheticTimestamp_date_time]
    def sampleId: Optional[SampleId]
    def subjectId: Optional[SubjectId]
    def generatedFrom: Optional[GeneratedFrom]
    def getName: ZIO[Any, AwsError, ReadSetName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.ReadSetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getReferenceArn: ZIO[Any, AwsError, ReferenceArn] =
      AwsError.unwrapOptionField("referenceArn", referenceArn)
    def getCreatedAfter: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getCreatedBefore: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
    def getSampleId: ZIO[Any, AwsError, SampleId] =
      AwsError.unwrapOptionField("sampleId", sampleId)
    def getSubjectId: ZIO[Any, AwsError, SubjectId] =
      AwsError.unwrapOptionField("subjectId", subjectId)
    def getGeneratedFrom: ZIO[Any, AwsError, GeneratedFrom] =
      AwsError.unwrapOptionField("generatedFrom", generatedFrom)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ReadSetFilter
  ) extends zio.aws.omics.model.ReadSetFilter.ReadOnly {
    override val name: Optional[ReadSetName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.ReadSetName(value))
    override val status: Optional[zio.aws.omics.model.ReadSetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.ReadSetStatus.wrap(value))
    override val referenceArn: Optional[ReferenceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceArn())
      .map(value => zio.aws.omics.model.primitives.ReferenceArn(value))
    override val createdAfter: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAfter())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val createdBefore: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBefore())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val sampleId: Optional[SampleId] = zio.aws.core.internal
      .optionalFromNullable(impl.sampleId())
      .map(value => zio.aws.omics.model.primitives.SampleId(value))
    override val subjectId: Optional[SubjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.subjectId())
      .map(value => zio.aws.omics.model.primitives.SubjectId(value))
    override val generatedFrom: Optional[GeneratedFrom] = zio.aws.core.internal
      .optionalFromNullable(impl.generatedFrom())
      .map(value => zio.aws.omics.model.primitives.GeneratedFrom(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ReadSetFilter
  ): zio.aws.omics.model.ReadSetFilter.ReadOnly = new Wrapper(impl)
}
