package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ReadSetName,
  SubjectId,
  SampleId,
  SequenceStoreId,
  SyntheticTimestamp_date_time,
  ReadSetDescription,
  ReadSetId,
  ReferenceArn,
  ReadSetArn,
  ReadSetStatusMessage
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ReadSetListItem(
    id: ReadSetId,
    arn: ReadSetArn,
    sequenceStoreId: SequenceStoreId,
    subjectId: Optional[SubjectId] = Optional.Absent,
    sampleId: Optional[SampleId] = Optional.Absent,
    status: zio.aws.omics.model.ReadSetStatus,
    name: Optional[ReadSetName] = Optional.Absent,
    description: Optional[ReadSetDescription] = Optional.Absent,
    referenceArn: Optional[ReferenceArn] = Optional.Absent,
    fileType: zio.aws.omics.model.FileType,
    sequenceInformation: Optional[zio.aws.omics.model.SequenceInformation] =
      Optional.Absent,
    creationTime: SyntheticTimestamp_date_time,
    statusMessage: Optional[ReadSetStatusMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ReadSetListItem = {
    import ReadSetListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ReadSetListItem
      .builder()
      .id(ReadSetId.unwrap(id): java.lang.String)
      .arn(ReadSetArn.unwrap(arn): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .optionallyWith(
        subjectId.map(value => SubjectId.unwrap(value): java.lang.String)
      )(_.subjectId)
      .optionallyWith(
        sampleId.map(value => SampleId.unwrap(value): java.lang.String)
      )(_.sampleId)
      .status(status.unwrap)
      .optionallyWith(
        name.map(value => ReadSetName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ReadSetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        referenceArn.map(value => ReferenceArn.unwrap(value): java.lang.String)
      )(_.referenceArn)
      .fileType(fileType.unwrap)
      .optionallyWith(sequenceInformation.map(value => value.buildAwsValue()))(
        _.sequenceInformation
      )
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .optionallyWith(
        statusMessage.map(value =>
          ReadSetStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ReadSetListItem.ReadOnly =
    zio.aws.omics.model.ReadSetListItem.wrap(buildAwsValue())
}
object ReadSetListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ReadSetListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ReadSetListItem =
      zio.aws.omics.model.ReadSetListItem(
        id,
        arn,
        sequenceStoreId,
        subjectId.map(value => value),
        sampleId.map(value => value),
        status,
        name.map(value => value),
        description.map(value => value),
        referenceArn.map(value => value),
        fileType,
        sequenceInformation.map(value => value.asEditable),
        creationTime,
        statusMessage.map(value => value)
      )
    def id: ReadSetId
    def arn: ReadSetArn
    def sequenceStoreId: SequenceStoreId
    def subjectId: Optional[SubjectId]
    def sampleId: Optional[SampleId]
    def status: zio.aws.omics.model.ReadSetStatus
    def name: Optional[ReadSetName]
    def description: Optional[ReadSetDescription]
    def referenceArn: Optional[ReferenceArn]
    def fileType: zio.aws.omics.model.FileType
    def sequenceInformation
        : Optional[zio.aws.omics.model.SequenceInformation.ReadOnly]
    def creationTime: SyntheticTimestamp_date_time
    def statusMessage: Optional[ReadSetStatusMessage]
    def getId: ZIO[Any, Nothing, ReadSetId] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, ReadSetArn] = ZIO.succeed(arn)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getSubjectId: ZIO[Any, AwsError, SubjectId] =
      AwsError.unwrapOptionField("subjectId", subjectId)
    def getSampleId: ZIO[Any, AwsError, SampleId] =
      AwsError.unwrapOptionField("sampleId", sampleId)
    def getStatus: ZIO[Any, Nothing, zio.aws.omics.model.ReadSetStatus] =
      ZIO.succeed(status)
    def getName: ZIO[Any, AwsError, ReadSetName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ReadSetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getReferenceArn: ZIO[Any, AwsError, ReferenceArn] =
      AwsError.unwrapOptionField("referenceArn", referenceArn)
    def getFileType: ZIO[Any, Nothing, zio.aws.omics.model.FileType] =
      ZIO.succeed(fileType)
    def getSequenceInformation
        : ZIO[Any, AwsError, zio.aws.omics.model.SequenceInformation.ReadOnly] =
      AwsError.unwrapOptionField("sequenceInformation", sequenceInformation)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getStatusMessage: ZIO[Any, AwsError, ReadSetStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ReadSetListItem
  ) extends zio.aws.omics.model.ReadSetListItem.ReadOnly {
    override val id: ReadSetId =
      zio.aws.omics.model.primitives.ReadSetId(impl.id())
    override val arn: ReadSetArn =
      zio.aws.omics.model.primitives.ReadSetArn(impl.arn())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val subjectId: Optional[SubjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.subjectId())
      .map(value => zio.aws.omics.model.primitives.SubjectId(value))
    override val sampleId: Optional[SampleId] = zio.aws.core.internal
      .optionalFromNullable(impl.sampleId())
      .map(value => zio.aws.omics.model.primitives.SampleId(value))
    override val status: zio.aws.omics.model.ReadSetStatus =
      zio.aws.omics.model.ReadSetStatus.wrap(impl.status())
    override val name: Optional[ReadSetName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.ReadSetName(value))
    override val description: Optional[ReadSetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.omics.model.primitives.ReadSetDescription(value))
    override val referenceArn: Optional[ReferenceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceArn())
      .map(value => zio.aws.omics.model.primitives.ReferenceArn(value))
    override val fileType: zio.aws.omics.model.FileType =
      zio.aws.omics.model.FileType.wrap(impl.fileType())
    override val sequenceInformation
        : Optional[zio.aws.omics.model.SequenceInformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sequenceInformation())
        .map(value => zio.aws.omics.model.SequenceInformation.wrap(value))
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val statusMessage: Optional[ReadSetStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.omics.model.primitives.ReadSetStatusMessage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ReadSetListItem
  ): zio.aws.omics.model.ReadSetListItem.ReadOnly = new Wrapper(impl)
}
