package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait ReadSetPartSource {
  def unwrap: software.amazon.awssdk.services.omics.model.ReadSetPartSource
}
object ReadSetPartSource {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.ReadSetPartSource
  ): zio.aws.omics.model.ReadSetPartSource = value match {
    case software.amazon.awssdk.services.omics.model.ReadSetPartSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.ReadSetPartSource.SOURCE1 =>
      val r = SOURCE1
      r
    case software.amazon.awssdk.services.omics.model.ReadSetPartSource.SOURCE2 =>
      val r = SOURCE2
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.omics.model.ReadSetPartSource {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReadSetPartSource =
      software.amazon.awssdk.services.omics.model.ReadSetPartSource.UNKNOWN_TO_SDK_VERSION
  }
  case object SOURCE1 extends zio.aws.omics.model.ReadSetPartSource {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReadSetPartSource =
      software.amazon.awssdk.services.omics.model.ReadSetPartSource.SOURCE1
  }
  case object SOURCE2 extends zio.aws.omics.model.ReadSetPartSource {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReadSetPartSource =
      software.amazon.awssdk.services.omics.model.ReadSetPartSource.SOURCE2
  }
}
