package zio.aws.omics.model
import zio.aws.omics.model.primitives.SyntheticTimestamp_date_time
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ReadSetUploadPartListFilter(
    createdAfter: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    createdBefore: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ReadSetUploadPartListFilter = {
    import ReadSetUploadPartListFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ReadSetUploadPartListFilter
      .builder()
      .optionallyWith(
        createdAfter.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAfter)
      .optionallyWith(
        createdBefore.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdBefore)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ReadSetUploadPartListFilter.ReadOnly =
    zio.aws.omics.model.ReadSetUploadPartListFilter.wrap(buildAwsValue())
}
object ReadSetUploadPartListFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ReadSetUploadPartListFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ReadSetUploadPartListFilter =
      zio.aws.omics.model.ReadSetUploadPartListFilter(
        createdAfter.map(value => value),
        createdBefore.map(value => value)
      )
    def createdAfter: Optional[SyntheticTimestamp_date_time]
    def createdBefore: Optional[SyntheticTimestamp_date_time]
    def getCreatedAfter: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getCreatedBefore: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ReadSetUploadPartListFilter
  ) extends zio.aws.omics.model.ReadSetUploadPartListFilter.ReadOnly {
    override val createdAfter: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAfter())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val createdBefore: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBefore())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ReadSetUploadPartListFilter
  ): zio.aws.omics.model.ReadSetUploadPartListFilter.ReadOnly = new Wrapper(
    impl
  )
}
