package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  SyntheticTimestamp_date_time,
  ReadSetUploadPartListItemPartSizeLong,
  ReadSetUploadPartListItemPartNumberInteger
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ReadSetUploadPartListItem(
    partNumber: ReadSetUploadPartListItemPartNumberInteger,
    partSize: ReadSetUploadPartListItemPartSizeLong,
    partSource: zio.aws.omics.model.ReadSetPartSource,
    checksum: String,
    creationTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    lastUpdatedTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ReadSetUploadPartListItem = {
    import ReadSetUploadPartListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ReadSetUploadPartListItem
      .builder()
      .partNumber(
        ReadSetUploadPartListItemPartNumberInteger.unwrap(partNumber): Integer
      )
      .partSize(
        ReadSetUploadPartListItemPartSizeLong.unwrap(partSize): java.lang.Long
      )
      .partSource(partSource.unwrap)
      .checksum(checksum: java.lang.String)
      .optionallyWith(
        creationTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.creationTime)
      .optionallyWith(
        lastUpdatedTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.lastUpdatedTime)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ReadSetUploadPartListItem.ReadOnly =
    zio.aws.omics.model.ReadSetUploadPartListItem.wrap(buildAwsValue())
}
object ReadSetUploadPartListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ReadSetUploadPartListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ReadSetUploadPartListItem =
      zio.aws.omics.model.ReadSetUploadPartListItem(
        partNumber,
        partSize,
        partSource,
        checksum,
        creationTime.map(value => value),
        lastUpdatedTime.map(value => value)
      )
    def partNumber: ReadSetUploadPartListItemPartNumberInteger
    def partSize: ReadSetUploadPartListItemPartSizeLong
    def partSource: zio.aws.omics.model.ReadSetPartSource
    def checksum: String
    def creationTime: Optional[SyntheticTimestamp_date_time]
    def lastUpdatedTime: Optional[SyntheticTimestamp_date_time]
    def getPartNumber
        : ZIO[Any, Nothing, ReadSetUploadPartListItemPartNumberInteger] =
      ZIO.succeed(partNumber)
    def getPartSize: ZIO[Any, Nothing, ReadSetUploadPartListItemPartSizeLong] =
      ZIO.succeed(partSize)
    def getPartSource
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetPartSource] =
      ZIO.succeed(partSource)
    def getChecksum: ZIO[Any, Nothing, String] = ZIO.succeed(checksum)
    def getCreationTime: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ReadSetUploadPartListItem
  ) extends zio.aws.omics.model.ReadSetUploadPartListItem.ReadOnly {
    override val partNumber: ReadSetUploadPartListItemPartNumberInteger =
      zio.aws.omics.model.primitives
        .ReadSetUploadPartListItemPartNumberInteger(impl.partNumber())
    override val partSize: ReadSetUploadPartListItemPartSizeLong =
      zio.aws.omics.model.primitives
        .ReadSetUploadPartListItemPartSizeLong(impl.partSize())
    override val partSource: zio.aws.omics.model.ReadSetPartSource =
      zio.aws.omics.model.ReadSetPartSource.wrap(impl.partSource())
    override val checksum: String = impl.checksum(): String
    override val creationTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val lastUpdatedTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTime())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ReadSetUploadPartListItem
  ): zio.aws.omics.model.ReadSetUploadPartListItem.ReadOnly = new Wrapper(impl)
}
