package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReferenceFiles(
    source: Optional[zio.aws.omics.model.FileInformation] = Optional.Absent,
    index: Optional[zio.aws.omics.model.FileInformation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ReferenceFiles = {
    import ReferenceFiles.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ReferenceFiles
      .builder()
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(index.map(value => value.buildAwsValue()))(_.index)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ReferenceFiles.ReadOnly =
    zio.aws.omics.model.ReferenceFiles.wrap(buildAwsValue())
}
object ReferenceFiles {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ReferenceFiles
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ReferenceFiles =
      zio.aws.omics.model.ReferenceFiles(
        source.map(value => value.asEditable),
        index.map(value => value.asEditable)
      )
    def source: Optional[zio.aws.omics.model.FileInformation.ReadOnly]
    def index: Optional[zio.aws.omics.model.FileInformation.ReadOnly]
    def getSource
        : ZIO[Any, AwsError, zio.aws.omics.model.FileInformation.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getIndex
        : ZIO[Any, AwsError, zio.aws.omics.model.FileInformation.ReadOnly] =
      AwsError.unwrapOptionField("index", index)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ReferenceFiles
  ) extends zio.aws.omics.model.ReferenceFiles.ReadOnly {
    override val source
        : Optional[zio.aws.omics.model.FileInformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.omics.model.FileInformation.wrap(value))
    override val index: Optional[zio.aws.omics.model.FileInformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.index())
        .map(value => zio.aws.omics.model.FileInformation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ReferenceFiles
  ): zio.aws.omics.model.ReferenceFiles.ReadOnly = new Wrapper(impl)
}
