package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait RunExport {
  def unwrap: software.amazon.awssdk.services.omics.model.RunExport
}
object RunExport {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.RunExport
  ): zio.aws.omics.model.RunExport = value match {
    case software.amazon.awssdk.services.omics.model.RunExport.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.RunExport.DEFINITION =>
      val r = DEFINITION
      r
  }
  case object unknownToSdkVersion extends zio.aws.omics.model.RunExport {
    override def unwrap: software.amazon.awssdk.services.omics.model.RunExport =
      software.amazon.awssdk.services.omics.model.RunExport.UNKNOWN_TO_SDK_VERSION
  }
  case object DEFINITION extends zio.aws.omics.model.RunExport {
    override def unwrap: software.amazon.awssdk.services.omics.model.RunExport =
      software.amazon.awssdk.services.omics.model.RunExport.DEFINITION
  }
}
