package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  RunGroupArn,
  RunGroupName,
  RunGroupListItemMaxDurationInteger,
  RunGroupListItemMaxRunsInteger,
  RunGroupTimestamp,
  RunGroupListItemMaxCpusInteger,
  RunGroupId,
  RunGroupListItemMaxGpusInteger
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RunGroupListItem(
    arn: Optional[RunGroupArn] = Optional.Absent,
    id: Optional[RunGroupId] = Optional.Absent,
    name: Optional[RunGroupName] = Optional.Absent,
    maxCpus: Optional[RunGroupListItemMaxCpusInteger] = Optional.Absent,
    maxRuns: Optional[RunGroupListItemMaxRunsInteger] = Optional.Absent,
    maxDuration: Optional[RunGroupListItemMaxDurationInteger] = Optional.Absent,
    creationTime: Optional[RunGroupTimestamp] = Optional.Absent,
    maxGpus: Optional[RunGroupListItemMaxGpusInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.RunGroupListItem = {
    import RunGroupListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.RunGroupListItem
      .builder()
      .optionallyWith(
        arn.map(value => RunGroupArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => RunGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => RunGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        maxCpus.map(value =>
          RunGroupListItemMaxCpusInteger.unwrap(value): Integer
        )
      )(_.maxCpus)
      .optionallyWith(
        maxRuns.map(value =>
          RunGroupListItemMaxRunsInteger.unwrap(value): Integer
        )
      )(_.maxRuns)
      .optionallyWith(
        maxDuration.map(value =>
          RunGroupListItemMaxDurationInteger.unwrap(value): Integer
        )
      )(_.maxDuration)
      .optionallyWith(
        creationTime.map(value => RunGroupTimestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        maxGpus.map(value =>
          RunGroupListItemMaxGpusInteger.unwrap(value): Integer
        )
      )(_.maxGpus)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.RunGroupListItem.ReadOnly =
    zio.aws.omics.model.RunGroupListItem.wrap(buildAwsValue())
}
object RunGroupListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.RunGroupListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.RunGroupListItem =
      zio.aws.omics.model.RunGroupListItem(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        maxCpus.map(value => value),
        maxRuns.map(value => value),
        maxDuration.map(value => value),
        creationTime.map(value => value),
        maxGpus.map(value => value)
      )
    def arn: Optional[RunGroupArn]
    def id: Optional[RunGroupId]
    def name: Optional[RunGroupName]
    def maxCpus: Optional[RunGroupListItemMaxCpusInteger]
    def maxRuns: Optional[RunGroupListItemMaxRunsInteger]
    def maxDuration: Optional[RunGroupListItemMaxDurationInteger]
    def creationTime: Optional[RunGroupTimestamp]
    def maxGpus: Optional[RunGroupListItemMaxGpusInteger]
    def getArn: ZIO[Any, AwsError, RunGroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, RunGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, RunGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getMaxCpus: ZIO[Any, AwsError, RunGroupListItemMaxCpusInteger] =
      AwsError.unwrapOptionField("maxCpus", maxCpus)
    def getMaxRuns: ZIO[Any, AwsError, RunGroupListItemMaxRunsInteger] =
      AwsError.unwrapOptionField("maxRuns", maxRuns)
    def getMaxDuration: ZIO[Any, AwsError, RunGroupListItemMaxDurationInteger] =
      AwsError.unwrapOptionField("maxDuration", maxDuration)
    def getCreationTime: ZIO[Any, AwsError, RunGroupTimestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getMaxGpus: ZIO[Any, AwsError, RunGroupListItemMaxGpusInteger] =
      AwsError.unwrapOptionField("maxGpus", maxGpus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.RunGroupListItem
  ) extends zio.aws.omics.model.RunGroupListItem.ReadOnly {
    override val arn: Optional[RunGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.omics.model.primitives.RunGroupArn(value))
    override val id: Optional[RunGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.omics.model.primitives.RunGroupId(value))
    override val name: Optional[RunGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.RunGroupName(value))
    override val maxCpus: Optional[RunGroupListItemMaxCpusInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxCpus())
        .map(value =>
          zio.aws.omics.model.primitives.RunGroupListItemMaxCpusInteger(value)
        )
    override val maxRuns: Optional[RunGroupListItemMaxRunsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxRuns())
        .map(value =>
          zio.aws.omics.model.primitives.RunGroupListItemMaxRunsInteger(value)
        )
    override val maxDuration: Optional[RunGroupListItemMaxDurationInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxDuration())
        .map(value =>
          zio.aws.omics.model.primitives
            .RunGroupListItemMaxDurationInteger(value)
        )
    override val creationTime: Optional[RunGroupTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => zio.aws.omics.model.primitives.RunGroupTimestamp(value))
    override val maxGpus: Optional[RunGroupListItemMaxGpusInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxGpus())
        .map(value =>
          zio.aws.omics.model.primitives.RunGroupListItemMaxGpusInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.RunGroupListItem
  ): zio.aws.omics.model.RunGroupListItem.ReadOnly = new Wrapper(impl)
}
