package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait RunLogLevel {
  def unwrap: software.amazon.awssdk.services.omics.model.RunLogLevel
}
object RunLogLevel {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.RunLogLevel
  ): zio.aws.omics.model.RunLogLevel = value match {
    case software.amazon.awssdk.services.omics.model.RunLogLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.RunLogLevel.OFF =>
      val r = OFF
      r
    case software.amazon.awssdk.services.omics.model.RunLogLevel.FATAL =>
      val r = FATAL
      r
    case software.amazon.awssdk.services.omics.model.RunLogLevel.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.omics.model.RunLogLevel.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion extends zio.aws.omics.model.RunLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.RunLogLevel =
      software.amazon.awssdk.services.omics.model.RunLogLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object OFF extends zio.aws.omics.model.RunLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.RunLogLevel =
      software.amazon.awssdk.services.omics.model.RunLogLevel.OFF
  }
  case object FATAL extends zio.aws.omics.model.RunLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.RunLogLevel =
      software.amazon.awssdk.services.omics.model.RunLogLevel.FATAL
  }
  case object ERROR extends zio.aws.omics.model.RunLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.RunLogLevel =
      software.amazon.awssdk.services.omics.model.RunLogLevel.ERROR
  }
  case object ALL extends zio.aws.omics.model.RunLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.RunLogLevel =
      software.amazon.awssdk.services.omics.model.RunLogLevel.ALL
  }
}
