package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait RunStatus {
  def unwrap: software.amazon.awssdk.services.omics.model.RunStatus
}
object RunStatus {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.RunStatus
  ): zio.aws.omics.model.RunStatus = value match {
    case software.amazon.awssdk.services.omics.model.RunStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.RunStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.omics.model.RunStatus.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.omics.model.RunStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.omics.model.RunStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.omics.model.RunStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.omics.model.RunStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.omics.model.RunStatus.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.omics.model.RunStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.omics.model.RunStatus {
    override def unwrap: software.amazon.awssdk.services.omics.model.RunStatus =
      software.amazon.awssdk.services.omics.model.RunStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.omics.model.RunStatus {
    override def unwrap: software.amazon.awssdk.services.omics.model.RunStatus =
      software.amazon.awssdk.services.omics.model.RunStatus.PENDING
  }
  case object STARTING extends zio.aws.omics.model.RunStatus {
    override def unwrap: software.amazon.awssdk.services.omics.model.RunStatus =
      software.amazon.awssdk.services.omics.model.RunStatus.STARTING
  }
  case object RUNNING extends zio.aws.omics.model.RunStatus {
    override def unwrap: software.amazon.awssdk.services.omics.model.RunStatus =
      software.amazon.awssdk.services.omics.model.RunStatus.RUNNING
  }
  case object STOPPING extends zio.aws.omics.model.RunStatus {
    override def unwrap: software.amazon.awssdk.services.omics.model.RunStatus =
      software.amazon.awssdk.services.omics.model.RunStatus.STOPPING
  }
  case object COMPLETED extends zio.aws.omics.model.RunStatus {
    override def unwrap: software.amazon.awssdk.services.omics.model.RunStatus =
      software.amazon.awssdk.services.omics.model.RunStatus.COMPLETED
  }
  case object DELETED extends zio.aws.omics.model.RunStatus {
    override def unwrap: software.amazon.awssdk.services.omics.model.RunStatus =
      software.amazon.awssdk.services.omics.model.RunStatus.DELETED
  }
  case object CANCELLED extends zio.aws.omics.model.RunStatus {
    override def unwrap: software.amazon.awssdk.services.omics.model.RunStatus =
      software.amazon.awssdk.services.omics.model.RunStatus.CANCELLED
  }
  case object FAILED extends zio.aws.omics.model.RunStatus {
    override def unwrap: software.amazon.awssdk.services.omics.model.RunStatus =
      software.amazon.awssdk.services.omics.model.RunStatus.FAILED
  }
}
