package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait SchemaValueType {
  def unwrap: software.amazon.awssdk.services.omics.model.SchemaValueType
}
object SchemaValueType {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.SchemaValueType
  ): zio.aws.omics.model.SchemaValueType = value match {
    case software.amazon.awssdk.services.omics.model.SchemaValueType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.SchemaValueType.LONG =>
      val r = LONG
      r
    case software.amazon.awssdk.services.omics.model.SchemaValueType.INT =>
      val r = INT
      r
    case software.amazon.awssdk.services.omics.model.SchemaValueType.STRING =>
      val r = STRING
      r
    case software.amazon.awssdk.services.omics.model.SchemaValueType.FLOAT =>
      val r = FLOAT
      r
    case software.amazon.awssdk.services.omics.model.SchemaValueType.DOUBLE =>
      val r = DOUBLE
      r
    case software.amazon.awssdk.services.omics.model.SchemaValueType.BOOLEAN =>
      val r = BOOLEAN
      r
  }
  case object unknownToSdkVersion extends zio.aws.omics.model.SchemaValueType {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.SchemaValueType =
      software.amazon.awssdk.services.omics.model.SchemaValueType.UNKNOWN_TO_SDK_VERSION
  }
  case object LONG extends zio.aws.omics.model.SchemaValueType {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.SchemaValueType =
      software.amazon.awssdk.services.omics.model.SchemaValueType.LONG
  }
  case object INT extends zio.aws.omics.model.SchemaValueType {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.SchemaValueType =
      software.amazon.awssdk.services.omics.model.SchemaValueType.INT
  }
  case object STRING extends zio.aws.omics.model.SchemaValueType {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.SchemaValueType =
      software.amazon.awssdk.services.omics.model.SchemaValueType.STRING
  }
  case object FLOAT extends zio.aws.omics.model.SchemaValueType {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.SchemaValueType =
      software.amazon.awssdk.services.omics.model.SchemaValueType.FLOAT
  }
  case object DOUBLE extends zio.aws.omics.model.SchemaValueType {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.SchemaValueType =
      software.amazon.awssdk.services.omics.model.SchemaValueType.DOUBLE
  }
  case object BOOLEAN extends zio.aws.omics.model.SchemaValueType {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.SchemaValueType =
      software.amazon.awssdk.services.omics.model.SchemaValueType.BOOLEAN
  }
}
