package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  SyntheticTimestamp_date_time,
  SequenceStoreName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class SequenceStoreFilter(
    name: Optional[SequenceStoreName] = Optional.Absent,
    createdAfter: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    createdBefore: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.SequenceStoreFilter = {
    import SequenceStoreFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.SequenceStoreFilter
      .builder()
      .optionallyWith(
        name.map(value => SequenceStoreName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        createdAfter.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAfter)
      .optionallyWith(
        createdBefore.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdBefore)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.SequenceStoreFilter.ReadOnly =
    zio.aws.omics.model.SequenceStoreFilter.wrap(buildAwsValue())
}
object SequenceStoreFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.SequenceStoreFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.SequenceStoreFilter =
      zio.aws.omics.model.SequenceStoreFilter(
        name.map(value => value),
        createdAfter.map(value => value),
        createdBefore.map(value => value)
      )
    def name: Optional[SequenceStoreName]
    def createdAfter: Optional[SyntheticTimestamp_date_time]
    def createdBefore: Optional[SyntheticTimestamp_date_time]
    def getName: ZIO[Any, AwsError, SequenceStoreName] =
      AwsError.unwrapOptionField("name", name)
    def getCreatedAfter: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getCreatedBefore: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.SequenceStoreFilter
  ) extends zio.aws.omics.model.SequenceStoreFilter.ReadOnly {
    override val name: Optional[SequenceStoreName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.SequenceStoreName(value))
    override val createdAfter: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAfter())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val createdBefore: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBefore())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.SequenceStoreFilter
  ): zio.aws.omics.model.SequenceStoreFilter.ReadOnly = new Wrapper(impl)
}
