package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.SseConfigKeyArnString
import scala.jdk.CollectionConverters._
final case class SseConfig(
    `type`: zio.aws.omics.model.EncryptionType,
    keyArn: Optional[SseConfigKeyArnString] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.omics.model.SseConfig = {
    import SseConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.SseConfig
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        keyArn.map(value =>
          SseConfigKeyArnString.unwrap(value): java.lang.String
        )
      )(_.keyArn)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.SseConfig.ReadOnly =
    zio.aws.omics.model.SseConfig.wrap(buildAwsValue())
}
object SseConfig {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.omics.model.SseConfig] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.SseConfig =
      zio.aws.omics.model.SseConfig(`type`, keyArn.map(value => value))
    def `type`: zio.aws.omics.model.EncryptionType
    def keyArn: Optional[SseConfigKeyArnString]
    def getType: ZIO[Any, Nothing, zio.aws.omics.model.EncryptionType] =
      ZIO.succeed(`type`)
    def getKeyArn: ZIO[Any, AwsError, SseConfigKeyArnString] =
      AwsError.unwrapOptionField("keyArn", keyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.SseConfig
  ) extends zio.aws.omics.model.SseConfig.ReadOnly {
    override val `type`: zio.aws.omics.model.EncryptionType =
      zio.aws.omics.model.EncryptionType.wrap(impl.`type`())
    override val keyArn: Optional[SseConfigKeyArnString] = zio.aws.core.internal
      .optionalFromNullable(impl.keyArn())
      .map(value => zio.aws.omics.model.primitives.SseConfigKeyArnString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.SseConfig
  ): zio.aws.omics.model.SseConfig.ReadOnly = new Wrapper(impl)
}
