package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{
  AnnotationFieldMapKeyString,
  AnnotationFieldMapValueString,
  StoreName,
  Arn,
  RunLeftNormalization
}
import scala.jdk.CollectionConverters._
final case class StartAnnotationImportJobRequest(
    destinationName: StoreName,
    roleArn: Arn,
    items: Iterable[zio.aws.omics.model.AnnotationImportItemSource],
    formatOptions: Optional[zio.aws.omics.model.FormatOptions] =
      Optional.Absent,
    runLeftNormalization: Optional[RunLeftNormalization] = Optional.Absent,
    annotationFields: Optional[
      Map[AnnotationFieldMapKeyString, AnnotationFieldMapValueString]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartAnnotationImportJobRequest = {
    import StartAnnotationImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartAnnotationImportJobRequest
      .builder()
      .destinationName(StoreName.unwrap(destinationName): java.lang.String)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(formatOptions.map(value => value.buildAwsValue()))(
        _.formatOptions
      )
      .optionallyWith(
        runLeftNormalization.map(value =>
          RunLeftNormalization.unwrap(value): java.lang.Boolean
        )
      )(_.runLeftNormalization)
      .optionallyWith(
        annotationFields.map(value =>
          value
            .map({ case (key, value) =>
              (AnnotationFieldMapKeyString.unwrap(
                key
              ): java.lang.String) -> (AnnotationFieldMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.annotationFields)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.StartAnnotationImportJobRequest.ReadOnly =
    zio.aws.omics.model.StartAnnotationImportJobRequest.wrap(buildAwsValue())
}
object StartAnnotationImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartAnnotationImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartAnnotationImportJobRequest =
      zio.aws.omics.model.StartAnnotationImportJobRequest(
        destinationName,
        roleArn,
        items.map { item =>
          item.asEditable
        },
        formatOptions.map(value => value.asEditable),
        runLeftNormalization.map(value => value),
        annotationFields.map(value => value)
      )
    def destinationName: StoreName
    def roleArn: Arn
    def items: List[zio.aws.omics.model.AnnotationImportItemSource.ReadOnly]
    def formatOptions: Optional[zio.aws.omics.model.FormatOptions.ReadOnly]
    def runLeftNormalization: Optional[RunLeftNormalization]
    def annotationFields: Optional[
      Map[AnnotationFieldMapKeyString, AnnotationFieldMapValueString]
    ]
    def getDestinationName: ZIO[Any, Nothing, StoreName] =
      ZIO.succeed(destinationName)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.omics.model.AnnotationImportItemSource.ReadOnly
    ]] = ZIO.succeed(items)
    def getFormatOptions
        : ZIO[Any, AwsError, zio.aws.omics.model.FormatOptions.ReadOnly] =
      AwsError.unwrapOptionField("formatOptions", formatOptions)
    def getRunLeftNormalization: ZIO[Any, AwsError, RunLeftNormalization] =
      AwsError.unwrapOptionField("runLeftNormalization", runLeftNormalization)
    def getAnnotationFields: ZIO[Any, AwsError, Map[
      AnnotationFieldMapKeyString,
      AnnotationFieldMapValueString
    ]] = AwsError.unwrapOptionField("annotationFields", annotationFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartAnnotationImportJobRequest
  ) extends zio.aws.omics.model.StartAnnotationImportJobRequest.ReadOnly {
    override val destinationName: StoreName =
      zio.aws.omics.model.primitives.StoreName(impl.destinationName())
    override val roleArn: Arn =
      zio.aws.omics.model.primitives.Arn(impl.roleArn())
    override val items
        : List[zio.aws.omics.model.AnnotationImportItemSource.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.omics.model.AnnotationImportItemSource.wrap(item)
      }
      .toList
    override val formatOptions
        : Optional[zio.aws.omics.model.FormatOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formatOptions())
        .map(value => zio.aws.omics.model.FormatOptions.wrap(value))
    override val runLeftNormalization: Optional[RunLeftNormalization] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runLeftNormalization())
        .map(value =>
          zio.aws.omics.model.primitives.RunLeftNormalization(value)
        )
    override val annotationFields: Optional[
      Map[AnnotationFieldMapKeyString, AnnotationFieldMapValueString]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.annotationFields())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives.AnnotationFieldMapKeyString(
              key
            ) -> zio.aws.omics.model.primitives
              .AnnotationFieldMapValueString(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartAnnotationImportJobRequest
  ): zio.aws.omics.model.StartAnnotationImportJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
