package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{ClientToken, SequenceStoreId}
import scala.jdk.CollectionConverters._
final case class StartReadSetActivationJobRequest(
    sequenceStoreId: SequenceStoreId,
    clientToken: Optional[ClientToken] = Optional.Absent,
    sources: Iterable[zio.aws.omics.model.StartReadSetActivationJobSourceItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartReadSetActivationJobRequest = {
    import StartReadSetActivationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartReadSetActivationJobRequest
      .builder()
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .sources(sources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.omics.model.StartReadSetActivationJobRequest.ReadOnly =
    zio.aws.omics.model.StartReadSetActivationJobRequest.wrap(buildAwsValue())
}
object StartReadSetActivationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartReadSetActivationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartReadSetActivationJobRequest =
      zio.aws.omics.model.StartReadSetActivationJobRequest(
        sequenceStoreId,
        clientToken.map(value => value),
        sources.map { item =>
          item.asEditable
        }
      )
    def sequenceStoreId: SequenceStoreId
    def clientToken: Optional[ClientToken]
    def sources
        : List[zio.aws.omics.model.StartReadSetActivationJobSourceItem.ReadOnly]
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getSources: ZIO[Any, Nothing, List[
      zio.aws.omics.model.StartReadSetActivationJobSourceItem.ReadOnly
    ]] = ZIO.succeed(sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartReadSetActivationJobRequest
  ) extends zio.aws.omics.model.StartReadSetActivationJobRequest.ReadOnly {
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.omics.model.primitives.ClientToken(value))
    override val sources: List[
      zio.aws.omics.model.StartReadSetActivationJobSourceItem.ReadOnly
    ] = impl
      .sources()
      .asScala
      .map { item =>
        zio.aws.omics.model.StartReadSetActivationJobSourceItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartReadSetActivationJobRequest
  ): zio.aws.omics.model.StartReadSetActivationJobRequest.ReadOnly =
    new Wrapper(impl)
}
