package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.omics.model.primitives.{
  SyntheticTimestamp_date_time,
  SequenceStoreId,
  ActivationJobId
}
import scala.jdk.CollectionConverters._
final case class StartReadSetActivationJobResponse(
    id: ActivationJobId,
    sequenceStoreId: SequenceStoreId,
    status: zio.aws.omics.model.ReadSetActivationJobStatus,
    creationTime: SyntheticTimestamp_date_time
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartReadSetActivationJobResponse = {
    import StartReadSetActivationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartReadSetActivationJobResponse
      .builder()
      .id(ActivationJobId.unwrap(id): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .status(status.unwrap)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.omics.model.StartReadSetActivationJobResponse.ReadOnly =
    zio.aws.omics.model.StartReadSetActivationJobResponse.wrap(buildAwsValue())
}
object StartReadSetActivationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartReadSetActivationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartReadSetActivationJobResponse =
      zio.aws.omics.model.StartReadSetActivationJobResponse(
        id,
        sequenceStoreId,
        status,
        creationTime
      )
    def id: ActivationJobId
    def sequenceStoreId: SequenceStoreId
    def status: zio.aws.omics.model.ReadSetActivationJobStatus
    def creationTime: SyntheticTimestamp_date_time
    def getId: ZIO[Any, Nothing, ActivationJobId] = ZIO.succeed(id)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetActivationJobStatus] =
      ZIO.succeed(status)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartReadSetActivationJobResponse
  ) extends zio.aws.omics.model.StartReadSetActivationJobResponse.ReadOnly {
    override val id: ActivationJobId =
      zio.aws.omics.model.primitives.ActivationJobId(impl.id())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val status: zio.aws.omics.model.ReadSetActivationJobStatus =
      zio.aws.omics.model.ReadSetActivationJobStatus.wrap(impl.status())
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartReadSetActivationJobResponse
  ): zio.aws.omics.model.StartReadSetActivationJobResponse.ReadOnly =
    new Wrapper(impl)
}
