package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.omics.model.primitives.{
  SyntheticTimestamp_date_time,
  S3Destination,
  SequenceStoreId,
  ExportJobId
}
import scala.jdk.CollectionConverters._
final case class StartReadSetExportJobResponse(
    id: ExportJobId,
    sequenceStoreId: SequenceStoreId,
    destination: S3Destination,
    status: zio.aws.omics.model.ReadSetExportJobStatus,
    creationTime: SyntheticTimestamp_date_time
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartReadSetExportJobResponse = {
    import StartReadSetExportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartReadSetExportJobResponse
      .builder()
      .id(ExportJobId.unwrap(id): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .destination(S3Destination.unwrap(destination): java.lang.String)
      .status(status.unwrap)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.StartReadSetExportJobResponse.ReadOnly =
    zio.aws.omics.model.StartReadSetExportJobResponse.wrap(buildAwsValue())
}
object StartReadSetExportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartReadSetExportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartReadSetExportJobResponse =
      zio.aws.omics.model.StartReadSetExportJobResponse(
        id,
        sequenceStoreId,
        destination,
        status,
        creationTime
      )
    def id: ExportJobId
    def sequenceStoreId: SequenceStoreId
    def destination: S3Destination
    def status: zio.aws.omics.model.ReadSetExportJobStatus
    def creationTime: SyntheticTimestamp_date_time
    def getId: ZIO[Any, Nothing, ExportJobId] = ZIO.succeed(id)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getDestination: ZIO[Any, Nothing, S3Destination] =
      ZIO.succeed(destination)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetExportJobStatus] =
      ZIO.succeed(status)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartReadSetExportJobResponse
  ) extends zio.aws.omics.model.StartReadSetExportJobResponse.ReadOnly {
    override val id: ExportJobId =
      zio.aws.omics.model.primitives.ExportJobId(impl.id())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val destination: S3Destination =
      zio.aws.omics.model.primitives.S3Destination(impl.destination())
    override val status: zio.aws.omics.model.ReadSetExportJobStatus =
      zio.aws.omics.model.ReadSetExportJobStatus.wrap(impl.status())
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartReadSetExportJobResponse
  ): zio.aws.omics.model.StartReadSetExportJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
