package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{ClientToken, RoleArn, SequenceStoreId}
import scala.jdk.CollectionConverters._
final case class StartReadSetImportJobRequest(
    sequenceStoreId: SequenceStoreId,
    roleArn: RoleArn,
    clientToken: Optional[ClientToken] = Optional.Absent,
    sources: Iterable[zio.aws.omics.model.StartReadSetImportJobSourceItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartReadSetImportJobRequest = {
    import StartReadSetImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartReadSetImportJobRequest
      .builder()
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .sources(sources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.StartReadSetImportJobRequest.ReadOnly =
    zio.aws.omics.model.StartReadSetImportJobRequest.wrap(buildAwsValue())
}
object StartReadSetImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartReadSetImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartReadSetImportJobRequest =
      zio.aws.omics.model.StartReadSetImportJobRequest(
        sequenceStoreId,
        roleArn,
        clientToken.map(value => value),
        sources.map { item =>
          item.asEditable
        }
      )
    def sequenceStoreId: SequenceStoreId
    def roleArn: RoleArn
    def clientToken: Optional[ClientToken]
    def sources
        : List[zio.aws.omics.model.StartReadSetImportJobSourceItem.ReadOnly]
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getSources: ZIO[Any, Nothing, List[
      zio.aws.omics.model.StartReadSetImportJobSourceItem.ReadOnly
    ]] = ZIO.succeed(sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartReadSetImportJobRequest
  ) extends zio.aws.omics.model.StartReadSetImportJobRequest.ReadOnly {
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val roleArn: RoleArn =
      zio.aws.omics.model.primitives.RoleArn(impl.roleArn())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.omics.model.primitives.ClientToken(value))
    override val sources
        : List[zio.aws.omics.model.StartReadSetImportJobSourceItem.ReadOnly] =
      impl
        .sources()
        .asScala
        .map { item =>
          zio.aws.omics.model.StartReadSetImportJobSourceItem.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartReadSetImportJobRequest
  ): zio.aws.omics.model.StartReadSetImportJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
