package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.omics.model.primitives.{
  SyntheticTimestamp_date_time,
  RoleArn,
  SequenceStoreId,
  ImportJobId
}
import scala.jdk.CollectionConverters._
final case class StartReadSetImportJobResponse(
    id: ImportJobId,
    sequenceStoreId: SequenceStoreId,
    roleArn: RoleArn,
    status: zio.aws.omics.model.ReadSetImportJobStatus,
    creationTime: SyntheticTimestamp_date_time
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartReadSetImportJobResponse = {
    import StartReadSetImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartReadSetImportJobResponse
      .builder()
      .id(ImportJobId.unwrap(id): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .status(status.unwrap)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.StartReadSetImportJobResponse.ReadOnly =
    zio.aws.omics.model.StartReadSetImportJobResponse.wrap(buildAwsValue())
}
object StartReadSetImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartReadSetImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartReadSetImportJobResponse =
      zio.aws.omics.model.StartReadSetImportJobResponse(
        id,
        sequenceStoreId,
        roleArn,
        status,
        creationTime
      )
    def id: ImportJobId
    def sequenceStoreId: SequenceStoreId
    def roleArn: RoleArn
    def status: zio.aws.omics.model.ReadSetImportJobStatus
    def creationTime: SyntheticTimestamp_date_time
    def getId: ZIO[Any, Nothing, ImportJobId] = ZIO.succeed(id)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetImportJobStatus] =
      ZIO.succeed(status)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartReadSetImportJobResponse
  ) extends zio.aws.omics.model.StartReadSetImportJobResponse.ReadOnly {
    override val id: ImportJobId =
      zio.aws.omics.model.primitives.ImportJobId(impl.id())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val roleArn: RoleArn =
      zio.aws.omics.model.primitives.RoleArn(impl.roleArn())
    override val status: zio.aws.omics.model.ReadSetImportJobStatus =
      zio.aws.omics.model.ReadSetImportJobStatus.wrap(impl.status())
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartReadSetImportJobResponse
  ): zio.aws.omics.model.StartReadSetImportJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
