package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{
  ReadSetName,
  SubjectId,
  SampleId,
  TagValue,
  ReadSetDescription,
  GeneratedFrom,
  ReferenceArn,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class StartReadSetImportJobSourceItem(
    sourceFiles: zio.aws.omics.model.SourceFiles,
    sourceFileType: zio.aws.omics.model.FileType,
    subjectId: SubjectId,
    sampleId: SampleId,
    generatedFrom: Optional[GeneratedFrom] = Optional.Absent,
    referenceArn: ReferenceArn,
    name: Optional[ReadSetName] = Optional.Absent,
    description: Optional[ReadSetDescription] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartReadSetImportJobSourceItem = {
    import StartReadSetImportJobSourceItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartReadSetImportJobSourceItem
      .builder()
      .sourceFiles(sourceFiles.buildAwsValue())
      .sourceFileType(sourceFileType.unwrap)
      .subjectId(SubjectId.unwrap(subjectId): java.lang.String)
      .sampleId(SampleId.unwrap(sampleId): java.lang.String)
      .optionallyWith(
        generatedFrom.map(value =>
          GeneratedFrom.unwrap(value): java.lang.String
        )
      )(_.generatedFrom)
      .referenceArn(ReferenceArn.unwrap(referenceArn): java.lang.String)
      .optionallyWith(
        name.map(value => ReadSetName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ReadSetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.StartReadSetImportJobSourceItem.ReadOnly =
    zio.aws.omics.model.StartReadSetImportJobSourceItem.wrap(buildAwsValue())
}
object StartReadSetImportJobSourceItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartReadSetImportJobSourceItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartReadSetImportJobSourceItem =
      zio.aws.omics.model.StartReadSetImportJobSourceItem(
        sourceFiles.asEditable,
        sourceFileType,
        subjectId,
        sampleId,
        generatedFrom.map(value => value),
        referenceArn,
        name.map(value => value),
        description.map(value => value),
        tags.map(value => value)
      )
    def sourceFiles: zio.aws.omics.model.SourceFiles.ReadOnly
    def sourceFileType: zio.aws.omics.model.FileType
    def subjectId: SubjectId
    def sampleId: SampleId
    def generatedFrom: Optional[GeneratedFrom]
    def referenceArn: ReferenceArn
    def name: Optional[ReadSetName]
    def description: Optional[ReadSetDescription]
    def tags: Optional[Map[TagKey, TagValue]]
    def getSourceFiles
        : ZIO[Any, Nothing, zio.aws.omics.model.SourceFiles.ReadOnly] =
      ZIO.succeed(sourceFiles)
    def getSourceFileType: ZIO[Any, Nothing, zio.aws.omics.model.FileType] =
      ZIO.succeed(sourceFileType)
    def getSubjectId: ZIO[Any, Nothing, SubjectId] = ZIO.succeed(subjectId)
    def getSampleId: ZIO[Any, Nothing, SampleId] = ZIO.succeed(sampleId)
    def getGeneratedFrom: ZIO[Any, AwsError, GeneratedFrom] =
      AwsError.unwrapOptionField("generatedFrom", generatedFrom)
    def getReferenceArn: ZIO[Any, Nothing, ReferenceArn] =
      ZIO.succeed(referenceArn)
    def getName: ZIO[Any, AwsError, ReadSetName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ReadSetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartReadSetImportJobSourceItem
  ) extends zio.aws.omics.model.StartReadSetImportJobSourceItem.ReadOnly {
    override val sourceFiles: zio.aws.omics.model.SourceFiles.ReadOnly =
      zio.aws.omics.model.SourceFiles.wrap(impl.sourceFiles())
    override val sourceFileType: zio.aws.omics.model.FileType =
      zio.aws.omics.model.FileType.wrap(impl.sourceFileType())
    override val subjectId: SubjectId =
      zio.aws.omics.model.primitives.SubjectId(impl.subjectId())
    override val sampleId: SampleId =
      zio.aws.omics.model.primitives.SampleId(impl.sampleId())
    override val generatedFrom: Optional[GeneratedFrom] = zio.aws.core.internal
      .optionalFromNullable(impl.generatedFrom())
      .map(value => zio.aws.omics.model.primitives.GeneratedFrom(value))
    override val referenceArn: ReferenceArn =
      zio.aws.omics.model.primitives.ReferenceArn(impl.referenceArn())
    override val name: Optional[ReadSetName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.ReadSetName(value))
    override val description: Optional[ReadSetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.omics.model.primitives.ReadSetDescription(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartReadSetImportJobSourceItem
  ): zio.aws.omics.model.StartReadSetImportJobSourceItem.ReadOnly = new Wrapper(
    impl
  )
}
