package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{ClientToken, RoleArn, ReferenceStoreId}
import scala.jdk.CollectionConverters._
final case class StartReferenceImportJobRequest(
    referenceStoreId: ReferenceStoreId,
    roleArn: RoleArn,
    clientToken: Optional[ClientToken] = Optional.Absent,
    sources: Iterable[zio.aws.omics.model.StartReferenceImportJobSourceItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartReferenceImportJobRequest = {
    import StartReferenceImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartReferenceImportJobRequest
      .builder()
      .referenceStoreId(
        ReferenceStoreId.unwrap(referenceStoreId): java.lang.String
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .sources(sources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.StartReferenceImportJobRequest.ReadOnly =
    zio.aws.omics.model.StartReferenceImportJobRequest.wrap(buildAwsValue())
}
object StartReferenceImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartReferenceImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartReferenceImportJobRequest =
      zio.aws.omics.model.StartReferenceImportJobRequest(
        referenceStoreId,
        roleArn,
        clientToken.map(value => value),
        sources.map { item =>
          item.asEditable
        }
      )
    def referenceStoreId: ReferenceStoreId
    def roleArn: RoleArn
    def clientToken: Optional[ClientToken]
    def sources
        : List[zio.aws.omics.model.StartReferenceImportJobSourceItem.ReadOnly]
    def getReferenceStoreId: ZIO[Any, Nothing, ReferenceStoreId] =
      ZIO.succeed(referenceStoreId)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getSources: ZIO[Any, Nothing, List[
      zio.aws.omics.model.StartReferenceImportJobSourceItem.ReadOnly
    ]] = ZIO.succeed(sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartReferenceImportJobRequest
  ) extends zio.aws.omics.model.StartReferenceImportJobRequest.ReadOnly {
    override val referenceStoreId: ReferenceStoreId =
      zio.aws.omics.model.primitives.ReferenceStoreId(impl.referenceStoreId())
    override val roleArn: RoleArn =
      zio.aws.omics.model.primitives.RoleArn(impl.roleArn())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.omics.model.primitives.ClientToken(value))
    override val sources
        : List[zio.aws.omics.model.StartReferenceImportJobSourceItem.ReadOnly] =
      impl
        .sources()
        .asScala
        .map { item =>
          zio.aws.omics.model.StartReferenceImportJobSourceItem.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartReferenceImportJobRequest
  ): zio.aws.omics.model.StartReferenceImportJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
