package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{
  S3Uri,
  TagValue,
  ReferenceName,
  ReferenceDescription,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class StartReferenceImportJobSourceItem(
    sourceFile: S3Uri,
    name: ReferenceName,
    description: Optional[ReferenceDescription] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartReferenceImportJobSourceItem = {
    import StartReferenceImportJobSourceItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartReferenceImportJobSourceItem
      .builder()
      .sourceFile(S3Uri.unwrap(sourceFile): java.lang.String)
      .name(ReferenceName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ReferenceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.omics.model.StartReferenceImportJobSourceItem.ReadOnly =
    zio.aws.omics.model.StartReferenceImportJobSourceItem.wrap(buildAwsValue())
}
object StartReferenceImportJobSourceItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartReferenceImportJobSourceItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartReferenceImportJobSourceItem =
      zio.aws.omics.model.StartReferenceImportJobSourceItem(
        sourceFile,
        name,
        description.map(value => value),
        tags.map(value => value)
      )
    def sourceFile: S3Uri
    def name: ReferenceName
    def description: Optional[ReferenceDescription]
    def tags: Optional[Map[TagKey, TagValue]]
    def getSourceFile: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(sourceFile)
    def getName: ZIO[Any, Nothing, ReferenceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, ReferenceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartReferenceImportJobSourceItem
  ) extends zio.aws.omics.model.StartReferenceImportJobSourceItem.ReadOnly {
    override val sourceFile: S3Uri =
      zio.aws.omics.model.primitives.S3Uri(impl.sourceFile())
    override val name: ReferenceName =
      zio.aws.omics.model.primitives.ReferenceName(impl.name())
    override val description: Optional[ReferenceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.omics.model.primitives.ReferenceDescription(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartReferenceImportJobSourceItem
  ): zio.aws.omics.model.StartReferenceImportJobSourceItem.ReadOnly =
    new Wrapper(impl)
}
