package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  RunRequestId,
  RunRoleArn,
  RunOutputUri,
  TagValue,
  StartRunRequestPriorityInteger,
  StartRunRequestStorageCapacityInteger,
  RunName,
  RunGroupId,
  WorkflowId,
  TagKey,
  RunId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import software.amazon.awssdk.core.document.Document
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StartRunRequest(
    workflowId: Optional[WorkflowId] = Optional.Absent,
    workflowType: Optional[zio.aws.omics.model.WorkflowType] = Optional.Absent,
    runId: Optional[RunId] = Optional.Absent,
    roleArn: RunRoleArn,
    name: Optional[RunName] = Optional.Absent,
    runGroupId: Optional[RunGroupId] = Optional.Absent,
    priority: Optional[StartRunRequestPriorityInteger] = Optional.Absent,
    parameters: Optional[zio.aws.omics.model.RunParameters] = Optional.Absent,
    storageCapacity: Optional[StartRunRequestStorageCapacityInteger] =
      Optional.Absent,
    outputUri: Optional[RunOutputUri] = Optional.Absent,
    logLevel: Optional[zio.aws.omics.model.RunLogLevel] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    requestId: RunRequestId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartRunRequest = {
    import StartRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartRunRequest
      .builder()
      .optionallyWith(
        workflowId.map(value => WorkflowId.unwrap(value): java.lang.String)
      )(_.workflowId)
      .optionallyWith(workflowType.map(value => value.unwrap))(_.workflowType)
      .optionallyWith(
        runId.map(value => RunId.unwrap(value): java.lang.String)
      )(_.runId)
      .roleArn(RunRoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        name.map(value => RunName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        runGroupId.map(value => RunGroupId.unwrap(value): java.lang.String)
      )(_.runGroupId)
      .optionallyWith(
        priority.map(value =>
          StartRunRequestPriorityInteger.unwrap(value): Integer
        )
      )(_.priority)
      .optionallyWith(parameters.map(value => value))(_.parameters)
      .optionallyWith(
        storageCapacity.map(value =>
          StartRunRequestStorageCapacityInteger.unwrap(value): Integer
        )
      )(_.storageCapacity)
      .optionallyWith(
        outputUri.map(value => RunOutputUri.unwrap(value): java.lang.String)
      )(_.outputUri)
      .optionallyWith(logLevel.map(value => value.unwrap))(_.logLevel)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .requestId(RunRequestId.unwrap(requestId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.StartRunRequest.ReadOnly =
    zio.aws.omics.model.StartRunRequest.wrap(buildAwsValue())
}
object StartRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartRunRequest =
      zio.aws.omics.model.StartRunRequest(
        workflowId.map(value => value),
        workflowType.map(value => value),
        runId.map(value => value),
        roleArn,
        name.map(value => value),
        runGroupId.map(value => value),
        priority.map(value => value),
        parameters.map(value => value),
        storageCapacity.map(value => value),
        outputUri.map(value => value),
        logLevel.map(value => value),
        tags.map(value => value),
        requestId
      )
    def workflowId: Optional[WorkflowId]
    def workflowType: Optional[zio.aws.omics.model.WorkflowType]
    def runId: Optional[RunId]
    def roleArn: RunRoleArn
    def name: Optional[RunName]
    def runGroupId: Optional[RunGroupId]
    def priority: Optional[StartRunRequestPriorityInteger]
    def parameters: Optional[Document]
    def storageCapacity: Optional[StartRunRequestStorageCapacityInteger]
    def outputUri: Optional[RunOutputUri]
    def logLevel: Optional[zio.aws.omics.model.RunLogLevel]
    def tags: Optional[Map[TagKey, TagValue]]
    def requestId: RunRequestId
    def getWorkflowId: ZIO[Any, AwsError, WorkflowId] =
      AwsError.unwrapOptionField("workflowId", workflowId)
    def getWorkflowType: ZIO[Any, AwsError, zio.aws.omics.model.WorkflowType] =
      AwsError.unwrapOptionField("workflowType", workflowType)
    def getRunId: ZIO[Any, AwsError, RunId] =
      AwsError.unwrapOptionField("runId", runId)
    def getRoleArn: ZIO[Any, Nothing, RunRoleArn] = ZIO.succeed(roleArn)
    def getName: ZIO[Any, AwsError, RunName] =
      AwsError.unwrapOptionField("name", name)
    def getRunGroupId: ZIO[Any, AwsError, RunGroupId] =
      AwsError.unwrapOptionField("runGroupId", runGroupId)
    def getPriority: ZIO[Any, AwsError, StartRunRequestPriorityInteger] =
      AwsError.unwrapOptionField("priority", priority)
    def getParameters: ZIO[Any, AwsError, Document] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getStorageCapacity
        : ZIO[Any, AwsError, StartRunRequestStorageCapacityInteger] =
      AwsError.unwrapOptionField("storageCapacity", storageCapacity)
    def getOutputUri: ZIO[Any, AwsError, RunOutputUri] =
      AwsError.unwrapOptionField("outputUri", outputUri)
    def getLogLevel: ZIO[Any, AwsError, zio.aws.omics.model.RunLogLevel] =
      AwsError.unwrapOptionField("logLevel", logLevel)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getRequestId: ZIO[Any, Nothing, RunRequestId] = ZIO.succeed(requestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartRunRequest
  ) extends zio.aws.omics.model.StartRunRequest.ReadOnly {
    override val workflowId: Optional[WorkflowId] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowId())
      .map(value => zio.aws.omics.model.primitives.WorkflowId(value))
    override val workflowType: Optional[zio.aws.omics.model.WorkflowType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowType())
        .map(value => zio.aws.omics.model.WorkflowType.wrap(value))
    override val runId: Optional[RunId] = zio.aws.core.internal
      .optionalFromNullable(impl.runId())
      .map(value => zio.aws.omics.model.primitives.RunId(value))
    override val roleArn: RunRoleArn =
      zio.aws.omics.model.primitives.RunRoleArn(impl.roleArn())
    override val name: Optional[RunName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.RunName(value))
    override val runGroupId: Optional[RunGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.runGroupId())
      .map(value => zio.aws.omics.model.primitives.RunGroupId(value))
    override val priority: Optional[StartRunRequestPriorityInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.priority())
        .map(value =>
          zio.aws.omics.model.primitives.StartRunRequestPriorityInteger(value)
        )
    override val parameters: Optional[Document] =
      zio.aws.core.internal.optionalFromNullable(impl.parameters())
    override val storageCapacity
        : Optional[StartRunRequestStorageCapacityInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageCapacity())
        .map(value =>
          zio.aws.omics.model.primitives
            .StartRunRequestStorageCapacityInteger(value)
        )
    override val outputUri: Optional[RunOutputUri] = zio.aws.core.internal
      .optionalFromNullable(impl.outputUri())
      .map(value => zio.aws.omics.model.primitives.RunOutputUri(value))
    override val logLevel: Optional[zio.aws.omics.model.RunLogLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logLevel())
        .map(value => zio.aws.omics.model.RunLogLevel.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val requestId: RunRequestId =
      zio.aws.omics.model.primitives.RunRequestId(impl.requestId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartRunRequest
  ): zio.aws.omics.model.StartRunRequest.ReadOnly = new Wrapper(impl)
}
