package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{
  AnnotationFieldMapKeyString,
  AnnotationFieldMapValueString,
  StoreName,
  Arn,
  RunLeftNormalization
}
import scala.jdk.CollectionConverters._
final case class StartVariantImportJobRequest(
    destinationName: StoreName,
    roleArn: Arn,
    items: Iterable[zio.aws.omics.model.VariantImportItemSource],
    runLeftNormalization: Optional[RunLeftNormalization] = Optional.Absent,
    annotationFields: Optional[
      Map[AnnotationFieldMapKeyString, AnnotationFieldMapValueString]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartVariantImportJobRequest = {
    import StartVariantImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartVariantImportJobRequest
      .builder()
      .destinationName(StoreName.unwrap(destinationName): java.lang.String)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        runLeftNormalization.map(value =>
          RunLeftNormalization.unwrap(value): java.lang.Boolean
        )
      )(_.runLeftNormalization)
      .optionallyWith(
        annotationFields.map(value =>
          value
            .map({ case (key, value) =>
              (AnnotationFieldMapKeyString.unwrap(
                key
              ): java.lang.String) -> (AnnotationFieldMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.annotationFields)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.StartVariantImportJobRequest.ReadOnly =
    zio.aws.omics.model.StartVariantImportJobRequest.wrap(buildAwsValue())
}
object StartVariantImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartVariantImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartVariantImportJobRequest =
      zio.aws.omics.model.StartVariantImportJobRequest(
        destinationName,
        roleArn,
        items.map { item =>
          item.asEditable
        },
        runLeftNormalization.map(value => value),
        annotationFields.map(value => value)
      )
    def destinationName: StoreName
    def roleArn: Arn
    def items: List[zio.aws.omics.model.VariantImportItemSource.ReadOnly]
    def runLeftNormalization: Optional[RunLeftNormalization]
    def annotationFields: Optional[
      Map[AnnotationFieldMapKeyString, AnnotationFieldMapValueString]
    ]
    def getDestinationName: ZIO[Any, Nothing, StoreName] =
      ZIO.succeed(destinationName)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.omics.model.VariantImportItemSource.ReadOnly
    ]] = ZIO.succeed(items)
    def getRunLeftNormalization: ZIO[Any, AwsError, RunLeftNormalization] =
      AwsError.unwrapOptionField("runLeftNormalization", runLeftNormalization)
    def getAnnotationFields: ZIO[Any, AwsError, Map[
      AnnotationFieldMapKeyString,
      AnnotationFieldMapValueString
    ]] = AwsError.unwrapOptionField("annotationFields", annotationFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartVariantImportJobRequest
  ) extends zio.aws.omics.model.StartVariantImportJobRequest.ReadOnly {
    override val destinationName: StoreName =
      zio.aws.omics.model.primitives.StoreName(impl.destinationName())
    override val roleArn: Arn =
      zio.aws.omics.model.primitives.Arn(impl.roleArn())
    override val items
        : List[zio.aws.omics.model.VariantImportItemSource.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.omics.model.VariantImportItemSource.wrap(item)
      }
      .toList
    override val runLeftNormalization: Optional[RunLeftNormalization] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runLeftNormalization())
        .map(value =>
          zio.aws.omics.model.primitives.RunLeftNormalization(value)
        )
    override val annotationFields: Optional[
      Map[AnnotationFieldMapKeyString, AnnotationFieldMapValueString]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.annotationFields())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives.AnnotationFieldMapKeyString(
              key
            ) -> zio.aws.omics.model.primitives
              .AnnotationFieldMapValueString(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartVariantImportJobRequest
  ): zio.aws.omics.model.StartVariantImportJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
