package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait StoreFormat {
  def unwrap: software.amazon.awssdk.services.omics.model.StoreFormat
}
object StoreFormat {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.StoreFormat
  ): zio.aws.omics.model.StoreFormat = value match {
    case software.amazon.awssdk.services.omics.model.StoreFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.StoreFormat.GFF =>
      val r = GFF
      r
    case software.amazon.awssdk.services.omics.model.StoreFormat.TSV =>
      val r = TSV
      r
    case software.amazon.awssdk.services.omics.model.StoreFormat.VCF =>
      val r = VCF
      r
  }
  case object unknownToSdkVersion extends zio.aws.omics.model.StoreFormat {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.StoreFormat =
      software.amazon.awssdk.services.omics.model.StoreFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object GFF extends zio.aws.omics.model.StoreFormat {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.StoreFormat =
      software.amazon.awssdk.services.omics.model.StoreFormat.GFF
  }
  case object TSV extends zio.aws.omics.model.StoreFormat {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.StoreFormat =
      software.amazon.awssdk.services.omics.model.StoreFormat.TSV
  }
  case object VCF extends zio.aws.omics.model.StoreFormat {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.StoreFormat =
      software.amazon.awssdk.services.omics.model.StoreFormat.VCF
  }
}
