package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StoreOptions(
    tsvStoreOptions: Optional[zio.aws.omics.model.TsvStoreOptions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StoreOptions = {
    import StoreOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StoreOptions
      .builder()
      .optionallyWith(tsvStoreOptions.map(value => value.buildAwsValue()))(
        _.tsvStoreOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.StoreOptions.ReadOnly =
    zio.aws.omics.model.StoreOptions.wrap(buildAwsValue())
}
object StoreOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StoreOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StoreOptions = zio.aws.omics.model
      .StoreOptions(tsvStoreOptions.map(value => value.asEditable))
    def tsvStoreOptions: Optional[zio.aws.omics.model.TsvStoreOptions.ReadOnly]
    def getTsvStoreOptions
        : ZIO[Any, AwsError, zio.aws.omics.model.TsvStoreOptions.ReadOnly] =
      AwsError.unwrapOptionField("tsvStoreOptions", tsvStoreOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StoreOptions
  ) extends zio.aws.omics.model.StoreOptions.ReadOnly {
    override val tsvStoreOptions
        : Optional[zio.aws.omics.model.TsvStoreOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tsvStoreOptions())
        .map(value => zio.aws.omics.model.TsvStoreOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StoreOptions
  ): zio.aws.omics.model.StoreOptions.ReadOnly = new Wrapper(impl)
}
