package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait StoreStatus {
  def unwrap: software.amazon.awssdk.services.omics.model.StoreStatus
}
object StoreStatus {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.StoreStatus
  ): zio.aws.omics.model.StoreStatus = value match {
    case software.amazon.awssdk.services.omics.model.StoreStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.StoreStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.omics.model.StoreStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.omics.model.StoreStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.omics.model.StoreStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.omics.model.StoreStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.omics.model.StoreStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.StoreStatus =
      software.amazon.awssdk.services.omics.model.StoreStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.omics.model.StoreStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.StoreStatus =
      software.amazon.awssdk.services.omics.model.StoreStatus.CREATING
  }
  case object UPDATING extends zio.aws.omics.model.StoreStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.StoreStatus =
      software.amazon.awssdk.services.omics.model.StoreStatus.UPDATING
  }
  case object DELETING extends zio.aws.omics.model.StoreStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.StoreStatus =
      software.amazon.awssdk.services.omics.model.StoreStatus.DELETING
  }
  case object ACTIVE extends zio.aws.omics.model.StoreStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.StoreStatus =
      software.amazon.awssdk.services.omics.model.StoreStatus.ACTIVE
  }
  case object FAILED extends zio.aws.omics.model.StoreStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.StoreStatus =
      software.amazon.awssdk.services.omics.model.StoreStatus.FAILED
  }
}
