package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait TaskStatus {
  def unwrap: software.amazon.awssdk.services.omics.model.TaskStatus
}
object TaskStatus {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.TaskStatus
  ): zio.aws.omics.model.TaskStatus = value match {
    case software.amazon.awssdk.services.omics.model.TaskStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.TaskStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.omics.model.TaskStatus.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.omics.model.TaskStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.omics.model.TaskStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.omics.model.TaskStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.omics.model.TaskStatus.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.omics.model.TaskStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.omics.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.TaskStatus =
      software.amazon.awssdk.services.omics.model.TaskStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.omics.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.TaskStatus =
      software.amazon.awssdk.services.omics.model.TaskStatus.PENDING
  }
  case object STARTING extends zio.aws.omics.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.TaskStatus =
      software.amazon.awssdk.services.omics.model.TaskStatus.STARTING
  }
  case object RUNNING extends zio.aws.omics.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.TaskStatus =
      software.amazon.awssdk.services.omics.model.TaskStatus.RUNNING
  }
  case object STOPPING extends zio.aws.omics.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.TaskStatus =
      software.amazon.awssdk.services.omics.model.TaskStatus.STOPPING
  }
  case object COMPLETED extends zio.aws.omics.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.TaskStatus =
      software.amazon.awssdk.services.omics.model.TaskStatus.COMPLETED
  }
  case object CANCELLED extends zio.aws.omics.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.TaskStatus =
      software.amazon.awssdk.services.omics.model.TaskStatus.CANCELLED
  }
  case object FAILED extends zio.aws.omics.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.TaskStatus =
      software.amazon.awssdk.services.omics.model.TaskStatus.FAILED
  }
}
