package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.{TagKey, TagArn}
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: TagArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.UntagResourceRequest
      .builder()
      .resourceArn(TagArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.UntagResourceRequest.ReadOnly =
    zio.aws.omics.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.UntagResourceRequest =
      zio.aws.omics.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: TagArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, TagArn] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.UntagResourceRequest
  ) extends zio.aws.omics.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: TagArn =
      zio.aws.omics.model.primitives.TagArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.omics.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.UntagResourceRequest
  ): zio.aws.omics.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
