package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.StoreDescription
import scala.jdk.CollectionConverters._
final case class UpdateAnnotationStoreRequest(
    name: String,
    description: Optional[StoreDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreRequest = {
    import UpdateAnnotationStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(
        description.map(value =>
          StoreDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.UpdateAnnotationStoreRequest.ReadOnly =
    zio.aws.omics.model.UpdateAnnotationStoreRequest.wrap(buildAwsValue())
}
object UpdateAnnotationStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.UpdateAnnotationStoreRequest =
      zio.aws.omics.model
        .UpdateAnnotationStoreRequest(name, description.map(value => value))
    def name: String
    def description: Optional[StoreDescription]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, StoreDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreRequest
  ) extends zio.aws.omics.model.UpdateAnnotationStoreRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val description: Optional[StoreDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.omics.model.primitives.StoreDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreRequest
  ): zio.aws.omics.model.UpdateAnnotationStoreRequest.ReadOnly = new Wrapper(
    impl
  )
}
