package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  UpdateTime,
  CreationTime,
  StoreDescription,
  ResourceId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class UpdateAnnotationStoreResponse(
    id: ResourceId,
    reference: zio.aws.omics.model.ReferenceItem,
    status: zio.aws.omics.model.StoreStatus,
    name: String,
    description: StoreDescription,
    creationTime: CreationTime,
    updateTime: UpdateTime,
    storeOptions: Optional[zio.aws.omics.model.StoreOptions] = Optional.Absent,
    storeFormat: Optional[zio.aws.omics.model.StoreFormat] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreResponse = {
    import UpdateAnnotationStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreResponse
      .builder()
      .id(ResourceId.unwrap(id): java.lang.String)
      .reference(reference.buildAwsValue())
      .status(status.unwrap)
      .name(name: java.lang.String)
      .description(StoreDescription.unwrap(description): java.lang.String)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .updateTime(UpdateTime.unwrap(updateTime): Instant)
      .optionallyWith(storeOptions.map(value => value.buildAwsValue()))(
        _.storeOptions
      )
      .optionallyWith(storeFormat.map(value => value.unwrap))(_.storeFormat)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.UpdateAnnotationStoreResponse.ReadOnly =
    zio.aws.omics.model.UpdateAnnotationStoreResponse.wrap(buildAwsValue())
}
object UpdateAnnotationStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.UpdateAnnotationStoreResponse =
      zio.aws.omics.model.UpdateAnnotationStoreResponse(
        id,
        reference.asEditable,
        status,
        name,
        description,
        creationTime,
        updateTime,
        storeOptions.map(value => value.asEditable),
        storeFormat.map(value => value)
      )
    def id: ResourceId
    def reference: zio.aws.omics.model.ReferenceItem.ReadOnly
    def status: zio.aws.omics.model.StoreStatus
    def name: String
    def description: StoreDescription
    def creationTime: CreationTime
    def updateTime: UpdateTime
    def storeOptions: Optional[zio.aws.omics.model.StoreOptions.ReadOnly]
    def storeFormat: Optional[zio.aws.omics.model.StoreFormat]
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
    def getReference
        : ZIO[Any, Nothing, zio.aws.omics.model.ReferenceItem.ReadOnly] =
      ZIO.succeed(reference)
    def getStatus: ZIO[Any, Nothing, zio.aws.omics.model.StoreStatus] =
      ZIO.succeed(status)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getDescription: ZIO[Any, Nothing, StoreDescription] =
      ZIO.succeed(description)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getUpdateTime: ZIO[Any, Nothing, UpdateTime] = ZIO.succeed(updateTime)
    def getStoreOptions
        : ZIO[Any, AwsError, zio.aws.omics.model.StoreOptions.ReadOnly] =
      AwsError.unwrapOptionField("storeOptions", storeOptions)
    def getStoreFormat: ZIO[Any, AwsError, zio.aws.omics.model.StoreFormat] =
      AwsError.unwrapOptionField("storeFormat", storeFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreResponse
  ) extends zio.aws.omics.model.UpdateAnnotationStoreResponse.ReadOnly {
    override val id: ResourceId =
      zio.aws.omics.model.primitives.ResourceId(impl.id())
    override val reference: zio.aws.omics.model.ReferenceItem.ReadOnly =
      zio.aws.omics.model.ReferenceItem.wrap(impl.reference())
    override val status: zio.aws.omics.model.StoreStatus =
      zio.aws.omics.model.StoreStatus.wrap(impl.status())
    override val name: String = impl.name(): String
    override val description: StoreDescription =
      zio.aws.omics.model.primitives.StoreDescription(impl.description())
    override val creationTime: CreationTime =
      zio.aws.omics.model.primitives.CreationTime(impl.creationTime())
    override val updateTime: UpdateTime =
      zio.aws.omics.model.primitives.UpdateTime(impl.updateTime())
    override val storeOptions
        : Optional[zio.aws.omics.model.StoreOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storeOptions())
        .map(value => zio.aws.omics.model.StoreOptions.wrap(value))
    override val storeFormat: Optional[zio.aws.omics.model.StoreFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storeFormat())
        .map(value => zio.aws.omics.model.StoreFormat.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreResponse
  ): zio.aws.omics.model.UpdateAnnotationStoreResponse.ReadOnly = new Wrapper(
    impl
  )
}
