package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.StoreDescription
import scala.jdk.CollectionConverters._
final case class UpdateVariantStoreRequest(
    name: String,
    description: Optional[StoreDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.UpdateVariantStoreRequest = {
    import UpdateVariantStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.UpdateVariantStoreRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(
        description.map(value =>
          StoreDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.UpdateVariantStoreRequest.ReadOnly =
    zio.aws.omics.model.UpdateVariantStoreRequest.wrap(buildAwsValue())
}
object UpdateVariantStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.UpdateVariantStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.UpdateVariantStoreRequest =
      zio.aws.omics.model
        .UpdateVariantStoreRequest(name, description.map(value => value))
    def name: String
    def description: Optional[StoreDescription]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, StoreDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.UpdateVariantStoreRequest
  ) extends zio.aws.omics.model.UpdateVariantStoreRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val description: Optional[StoreDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.omics.model.primitives.StoreDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.UpdateVariantStoreRequest
  ): zio.aws.omics.model.UpdateVariantStoreRequest.ReadOnly = new Wrapper(impl)
}
